/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.parser;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeUtil {
    public static final String FORMAT_PATTERN = "yyyy-MM-dd kk:mm:ss.SSS";

    public static Date parse(String ds) {
        String[] tokens = ds.split("\\.");
        if (tokens.length != 2) {
            throw new RuntimeException("Invalid date string: " + ds);
        }
        int fractionalSecs = Integer.parseInt(tokens[1]) / 1000;
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd k:m:s.SSS").parse(String.format("%s.%03d", tokens[0], fractionalSecs));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static String format(Date date) {
        Object milliseconds = new SimpleDateFormat(FORMAT_PATTERN).format(date);
        if (date instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)date;
            int nanos = timestamp.getNanos();
            int microseconds = nanos / 1000;
            milliseconds = ((String)milliseconds).substring(0, ((String)milliseconds).indexOf(".") + 1) + String.format("%06d", microseconds);
        }
        return milliseconds;
    }
}

