/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.postgres;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.postgresql.util.PGobject;
import org.zalando.typemapper.parser.exception.HStoreParseException;
import org.zalando.typemapper.postgres.AbstractPgSerializer;
import org.zalando.typemapper.postgres.PgTypeHelper;

public class HStore
extends PGobject
implements Iterable<Map.Entry<String, String>> {
    private static final long serialVersionUID = -2491617655490561600L;
    private int length;
    private static final char QUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private static final char EQUALS = '=';
    private static final char GREATER = '>';
    private static final char COMMA = ',';
    private static final String NULL = "NULL";

    public HStore(String rawValue) {
        this.type = "hstore";
        this.value = rawValue;
        this.length = rawValue == null ? 0 : rawValue.length();
    }

    public HStore() {
        this.type = "hstore";
        this.length = 0;
    }

    public HStore(Map<?, ?> map) {
        this(new HStoreSerializer(map).toPgString(null));
    }

    public void setValue(String rawValue) {
        if (!"hstore".equals(this.type)) {
            throw new IllegalStateException("HStore database type name should be 'hstore'");
        }
        this.value = rawValue;
        this.length = rawValue == null ? 0 : rawValue.length();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> r = new HashMap<String, String>();
        try {
            HStoreIterator iterator = new HStoreIterator();
            while (iterator.hasNext()) {
                HStoreEntry entry = iterator.rawNext();
                r.put(entry.key, entry.value);
            }
        }
        catch (HStoreParseException e) {
            throw new IllegalStateException(e);
        }
        return r;
    }

    public static String serialize(Map<?, ?> map) {
        return new HStoreSerializer(map).toPgString(null);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        try {
            return new HStoreIterator();
        }
        catch (HStoreParseException e) {
            throw new IllegalStateException(e);
        }
    }

    private class HStoreIterator
    implements Iterator<Map.Entry<String, String>> {
        private int position = -1;
        private HStoreEntry lastReturned;
        private HStoreEntry nextEntry;

        public HStoreIterator() throws HStoreParseException {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        private HStoreEntry rawNext() throws NoSuchElementException, HStoreParseException {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public Map.Entry<String, String> next() throws NoSuchElementException, IllegalStateException {
            try {
                return this.rawNext();
            }
            catch (HStoreParseException e) {
                throw new IllegalStateException(e);
            }
        }

        private void advance() throws HStoreParseException {
            String elementKey = null;
            String elementValue = null;
            ParseState state = ParseState.WaitingForKey;
            block7: while (this.position < HStore.this.length - 1) {
                char ch = HStore.this.value.charAt(++this.position);
                switch (state) {
                    case WaitingForKey: {
                        if (Character.isWhitespace(ch)) continue block7;
                        elementKey = ch == '\"' ? this.advanceQuoted() : this.advanceWord('=');
                        state = ParseState.WaitingForEquals;
                        continue block7;
                    }
                    case WaitingForEquals: {
                        if (Character.isWhitespace(ch)) continue block7;
                        if (ch == '=') {
                            state = ParseState.WaitingForGreater;
                            continue block7;
                        }
                        throw new HStoreParseException("Expected '=>' key-value separator", this.position);
                    }
                    case WaitingForGreater: {
                        if (ch == '>') {
                            state = ParseState.WaitingForValue;
                            continue block7;
                        }
                        throw new HStoreParseException("Expected '=>' key-value separator", this.position);
                    }
                    case WaitingForValue: {
                        if (Character.isWhitespace(ch)) continue block7;
                        if (ch == '\"') {
                            elementValue = this.advanceQuoted();
                        } else {
                            elementValue = this.advanceWord(',');
                            if (HStore.NULL.equalsIgnoreCase(elementValue)) {
                                elementValue = null;
                            }
                        }
                        state = ParseState.WaitingForComma;
                        continue block7;
                    }
                    case WaitingForComma: {
                        if (Character.isWhitespace(ch)) continue block7;
                        if (ch == ',') break block7;
                        throw new HStoreParseException("Cannot find comma as an end of the value: '" + HStore.this.value + "'", this.position);
                    }
                    default: {
                        throw new IllegalStateException("Unknown HStoreParser state");
                    }
                }
            }
            if (state == ParseState.WaitingForKey) {
                this.nextEntry = null;
                return;
            }
            if (state != ParseState.WaitingForComma) {
                throw new HStoreParseException("Unexpected end of string", this.position);
            }
            if (elementKey == null) {
                throw new HStoreParseException("Internal parsing error", this.position);
            }
            this.nextEntry = new HStoreEntry(elementKey, elementValue);
        }

        private String advanceQuoted() throws HStoreParseException {
            int firstQuotePosition = this.position;
            StringBuilder sb = null;
            boolean insideQuote = true;
            while (this.position < HStore.this.length - 1) {
                char ch = HStore.this.value.charAt(++this.position);
                if (ch == '\\') {
                    int nextPosition = this.position + 1;
                    if (nextPosition < HStore.this.length) {
                        char nextCh = HStore.this.value.charAt(nextPosition);
                        if (nextCh == '\"') {
                            if (sb == null) {
                                sb = new StringBuilder(HStore.this.value.substring(firstQuotePosition + 1, this.position));
                            }
                            sb.append('\"');
                            ++this.position;
                            continue;
                        }
                        if (nextCh == '\\') {
                            if (sb == null) {
                                sb = new StringBuilder(HStore.this.value.substring(firstQuotePosition + 1, this.position));
                            }
                            sb.append('\\');
                            ++this.position;
                            continue;
                        }
                    }
                    throw new HStoreParseException("Backslash without following backslash or quote at position " + this.position, this.position);
                }
                if (ch == '\"') {
                    insideQuote = false;
                    break;
                }
                if (sb == null) continue;
                sb.append(ch);
            }
            if (insideQuote) {
                throw new HStoreParseException("Quote at string position " + firstQuotePosition + " is not closed", this.position);
            }
            if (sb == null) {
                String r = HStore.this.value.substring(firstQuotePosition + 1, this.position);
                return r;
            }
            return sb.toString();
        }

        private String advanceWord(char stopAtChar) throws HStoreParseException {
            int firstWordPosition = this.position;
            while (this.position < HStore.this.length) {
                char ch = HStore.this.value.charAt(this.position);
                if (ch == '\"') {
                    throw new HStoreParseException("Unexpected quote in word", this.position);
                }
                if (Character.isWhitespace(ch) || ch == stopAtChar) break;
                ++this.position;
            }
            --this.position;
            String r = HStore.this.value.substring(firstWordPosition, this.position + 1);
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ParseState {
        WaitingForKey,
        WaitingForEquals,
        WaitingForGreater,
        WaitingForValue,
        WaitingForComma;

    }

    private static class HStoreEntry
    implements Map.Entry<String, String> {
        private String key;
        private String value;

        HStoreEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            String oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }

    private static final class HStoreSerializer
    extends AbstractPgSerializer {
        private final Map<Object, Object> map;

        protected HStoreSerializer(Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public boolean isNull() {
            return this.map == null;
        }

        @Override
        protected boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        protected String getEmpty() {
            return "\"\"";
        }

        @Override
        protected void appendNull(StringBuilder sb) {
            sb.append(HStore.NULL);
        }

        @Override
        public StringBuilder quote(StringBuilder sb, CharSequence s) {
            char ch;
            int i;
            if (sb == null) {
                throw new NullPointerException("Passed StringBuilder should be not null");
            }
            if (s == null) {
                throw new NullPointerException("Null values should be processed by the caller");
            }
            int l = s.length();
            if (l == 0) {
                return sb.append("\"\"");
            }
            int neededLength = 0;
            for (i = 0; i < l; ++i) {
                ch = s.charAt(i);
                ++neededLength;
                if (ch != '\"' && ch != '\\') continue;
                ++neededLength;
            }
            sb.ensureCapacity(sb.length() + neededLength + 2);
            sb.append('\"');
            for (i = 0; i < l; ++i) {
                ch = s.charAt(i);
                if (ch == '\"' || ch == '\\') {
                    sb.append('\\').append(ch);
                    continue;
                }
                sb.append(ch);
            }
            sb.append('\"');
            return sb;
        }

        @Override
        public String toPgString(Connection connection) {
            Iterator<Map.Entry<Object, Object>> iterator = this.map.entrySet().iterator();
            StringBuilder sb = new StringBuilder();
            boolean hasNext = iterator.hasNext();
            while (hasNext) {
                Map.Entry<Object, Object> entry = iterator.next();
                assert (entry != null);
                Object key = entry.getKey();
                if (key == null) {
                    throw new IllegalArgumentException("Null keys are not supported by HStore");
                }
                this.quote(sb, PgTypeHelper.toPgString(key));
                sb.append("=>");
                Object value = entry.getValue();
                if (value == null) {
                    sb.append(HStore.NULL);
                } else {
                    this.quote(sb, PgTypeHelper.toPgString(value));
                }
                hasNext = iterator.hasNext();
                if (!hasNext) break;
                sb.append(',');
            }
            return sb.toString();
        }
    }
}

