/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.postgres;

import com.google.common.base.Objects;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.zalando.typemapper.postgres.AbstractPgCollectionSerializer;
import org.zalando.typemapper.postgres.PgRow;
import org.zalando.typemapper.postgres.PgTypeHelper;

public final class PgArray<E>
implements Array {
    private String elementTypeName = null;
    private final PgArraySerializer<E> serializer;
    private String serializedString = null;

    protected PgArray(String elementTypeName, Collection<E> c) {
        this.serializer = new PgArraySerializer<E>(c);
        this.elementTypeName = elementTypeName;
    }

    @SafeVarargs
    public static <T> PgArray<T> ARRAY(T ... array) {
        return PgArray.ARRAY(Arrays.asList(array));
    }

    public static <T> PgArray<T> ARRAY(Collection<T> collection) {
        Class<?> elementClass = null;
        String type = null;
        for (T element : collection) {
            if (element == null) continue;
            elementClass = element.getClass();
            if (!PgRow.class.isAssignableFrom(elementClass)) break;
            type = ((PgRow)((Object)element)).getType();
            break;
        }
        if (type != null) {
            return new PgArray<T>(type, collection);
        }
        return new PgArray<T>(PgTypeHelper.getSQLNameForClass(elementClass), collection);
    }

    public String toString() {
        if (this.serializedString != null) {
            return this.serializedString;
        }
        return this.serializer.toString();
    }

    public String toString(Connection connection) {
        return this.serializer.toString(connection);
    }

    public Array asJdbcArray(String elementTypeName) {
        this.elementTypeName = elementTypeName;
        return this;
    }

    public Array asJdbcArray(String elementTypeName, Connection connection) {
        this.elementTypeName = elementTypeName;
        this.serializedString = this.serializer.toString(connection);
        return this;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.elementTypeName == null) {
            throw new SQLException("Array element type is not defined, use asJdbcArray(<elementTypeName>) to get a valid java.sql.Array object");
        }
        return this.elementTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        if (this.elementTypeName == null) {
            throw new SQLException("Array element type is not defined, use asJdbcArray(<elementTypeName>) to get a valid java.sql.Array object");
        }
        return PgTypeHelper.getSQLType(this.elementTypeName);
    }

    @Override
    public Object getArray() throws SQLException {
        return this.serializer.collection.toArray();
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void free() throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.elementTypeName, this.serializer.collection});
    }

    public boolean equals(Object obj) {
        if (obj instanceof PgArray) {
            PgArray other = (PgArray)obj;
            return Objects.equal((Object)this.elementTypeName, (Object)other.elementTypeName) && Objects.equal((Object)this.serializer.collection, (Object)other.serializer.collection);
        }
        return false;
    }

    private static class PgArraySerializer<E>
    extends AbstractPgCollectionSerializer<E> {
        protected PgArraySerializer(Collection<E> c) {
            super(c);
        }

        @Override
        protected char getOpeningChar() {
            return '{';
        }

        @Override
        protected char getClosingChar() {
            return '}';
        }

        @Override
        protected void quoteChar(StringBuilder sb, char ch) {
            sb.append('\\').append(ch);
        }

        @Override
        protected void appendNull(StringBuilder sb) {
            sb.append("NULL");
        }
    }
}

