/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.globalobjecttransformer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.globalobjecttransformer.annotation.GlobalObjectMapper;
import org.zalando.typemapper.core.fieldMapper.ObjectMapper;

public class GlobalObjectTransformerLoader {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalObjectTransformerLoader.class);
    private static final String DEFAULT_NAMESPACE = "org.zalando";
    private static final String GLOBAL_OBJECT_TRANSFORMER_SEARCH_NAMESPACE = "global.object.transformer.search.namespace";
    private static volatile String namespaceToScan = null;
    private static volatile ImmutableMap<Class<?>, ObjectMapper<?>> register;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> ObjectMapper<T> getObjectMapperForClass(Class<T> genericType) throws InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, IllegalArgumentException, NoSuchMethodException {
        Preconditions.checkNotNull(genericType, (Object)"genericType");
        ImmutableMap<Class<?>, ObjectMapper<?>> localRegister = register;
        if (localRegister != null) return (ObjectMapper)localRegister.get(genericType);
        Class<GlobalObjectTransformerLoader> clazz = GlobalObjectTransformerLoader.class;
        synchronized (GlobalObjectTransformerLoader.class) {
            localRegister = register;
            if (localRegister != null) return (ObjectMapper)localRegister.get(genericType);
            register = localRegister = GlobalObjectTransformerLoader.buildMappers();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (ObjectMapper)localRegister.get(genericType);
        }
    }

    private static ImmutableMap<Class<?>, ObjectMapper<?>> buildMappers() throws InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, IllegalArgumentException, NoSuchMethodException {
        HashMap mappers = new HashMap();
        for (Class<?> foundGlobalObjectTransformer : GlobalObjectTransformerLoader.findObjectMappers()) {
            if (ObjectMapper.class.isAssignableFrom(foundGlobalObjectTransformer)) {
                ObjectMapper mapper = (ObjectMapper)foundGlobalObjectTransformer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Class valueTransformerReturnType = mapper.getType();
                ObjectMapper previousMapper = mappers.put(valueTransformerReturnType, mapper);
                if (previousMapper == null) {
                    LOG.debug("Global Object Mapper [{}] for type [{}] registered. ", (Object)foundGlobalObjectTransformer.getSimpleName(), (Object)valueTransformerReturnType.getSimpleName());
                    continue;
                }
                LOG.error("Found multiple global object mappers for type [{}]. [{}] replaced by [{}]", new Object[]{valueTransformerReturnType, previousMapper.getClass().getSimpleName(), valueTransformerReturnType.getSimpleName()});
                continue;
            }
            LOG.error("Object mapper [{}] should extend [{}]", (Object)foundGlobalObjectTransformer.getSimpleName(), (Object)ObjectMapper.class.getSimpleName());
        }
        return ImmutableMap.copyOf(mappers);
    }

    private static Set<Class<?>> findObjectMappers() {
        Predicate<String> filter = input -> GlobalObjectMapper.class.getCanonicalName().equals(input);
        String myNameSpaceToScan = GlobalObjectTransformerLoader.getNameSpace();
        Scanner[] scannerArray = new Scanner[2];
        scannerArray[0] = new TypeAnnotationsScanner().filterResultsBy(filter::test);
        scannerArray[1] = new SubTypesScanner();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)myNameSpaceToScan))).setUrls(ClasspathHelper.forPackage((String)myNameSpaceToScan, (ClassLoader[])new ClassLoader[0])).setScanners(scannerArray));
        return reflections.getTypesAnnotatedWith(GlobalObjectMapper.class);
    }

    private static String getNameSpace() {
        String myNameSpaceToScan = namespaceToScan;
        if (myNameSpaceToScan == null) {
            try {
                myNameSpaceToScan = System.getenv(GLOBAL_OBJECT_TRANSFORMER_SEARCH_NAMESPACE);
            }
            catch (Exception e) {
                LOG.warn("Could not get the value of environment variable: {}. Using: {}", new Object[]{GLOBAL_OBJECT_TRANSFORMER_SEARCH_NAMESPACE, namespaceToScan, e});
            }
            if (myNameSpaceToScan == null) {
                myNameSpaceToScan = DEFAULT_NAMESPACE;
            }
        }
        return myNameSpaceToScan;
    }

    public static void changeNamespaceToScan(String newNamespace) {
        namespaceToScan = (String)Preconditions.checkNotNull((Object)newNamespace, (Object)"newNamespace");
        register = null;
    }
}

