/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy;

import com.google.common.base.MoreObjects;
import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.dsprovider.DataSourceProvider;
import org.zalando.sprocwrapper.proxy.InvocationContext;
import org.zalando.sprocwrapper.proxy.StoredProcedure;

class SProcProxy
extends AbstractInvocationHandler {
    private final HashMap<Method, StoredProcedure> sprocs = new HashMap();
    private final DataSourceProvider dataSourceProvider;
    private static final Logger LOG = LoggerFactory.getLogger(SProcProxy.class);
    private final String description;

    public boolean addStoredProcedure(Method method, StoredProcedure p) {
        if (this.sprocs.containsKey(method)) {
            return false;
        }
        this.sprocs.put(method, p);
        return true;
    }

    public SProcProxy(DataSourceProvider provider, String description) {
        if (provider == null) {
            throw new IllegalArgumentException("DataSourceProvider cannot be null");
        }
        this.dataSourceProvider = provider;
        this.description = description;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) {
        StoredProcedure p = this.sprocs.get(method);
        if (p == null) {
            LOG.warn("no StoredProcedure found for method {}", (Object)method);
            return null;
        }
        return p.execute(this.dataSourceProvider, new InvocationContext(proxy, method, args));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).addValue((Object)this.description).add("dataSourceProvider", (Object)this.dataSourceProvider).toString();
    }
}

