/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.result;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.zalando.typemapper.core.db.DbType;
import org.zalando.typemapper.core.db.DbTypeRegister;
import org.zalando.typemapper.core.result.DbResultNode;
import org.zalando.typemapper.core.result.DbResultNodeType;
import org.zalando.typemapper.core.result.ObjectResultNode;
import org.zalando.typemapper.core.result.SimpleResultNode;
import org.zalando.typemapper.parser.exception.ArrayParserException;
import org.zalando.typemapper.parser.postgres.ParseUtils;

public class ArrayResultNode
implements DbResultNode {
    private String name;
    private String type;
    private int typeId;
    private List<DbResultNode> children;
    private DbType typeDef;

    public ArrayResultNode(String name, String value, String typeName, int typeId, Connection connection) throws SQLException {
        this.name = name;
        this.type = typeName;
        this.typeId = typeId;
        this.typeDef = DbTypeRegister.getDbType(typeId, connection);
        this.children = new ArrayList<DbResultNode>();
        if (value != null) {
            List<String> elements;
            try {
                elements = ParseUtils.postgresArray2StringList(value);
            }
            catch (ArrayParserException e) {
                throw new SQLException("Failed to parse array " + name + " of type " + typeName, e);
            }
            for (String element : elements) {
                if (this.typeDef != null) {
                    this.children.add(new ObjectResultNode(element, "", typeName, typeId, connection));
                    continue;
                }
                this.children.add(new SimpleResultNode(element, ""));
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DbResultNodeType getNodeType() {
        return DbResultNodeType.ARRAY;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public List<DbResultNode> getChildren() {
        return this.children;
    }

    @Override
    public DbResultNode getChildByName(String name) {
        return null;
    }

    public String toString() {
        return "ArrayResultNode [name=" + this.name + ", type=" + this.type + ", typeId=" + this.typeId + ", children=" + this.children + ", typeDef=" + this.typeDef + "]";
    }
}

