/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zalando.typemapper.core.db.DbFunction;
import org.zalando.typemapper.core.db.DbTypeField;
import org.zalando.typemapper.core.db.DbTypeRegister;
import org.zalando.typemapper.core.db.SearchPathSchemaFilter;

public class DbFunctionRegister {
    private static final String FUNCTION_DETAILS = "SELECT ss.n_nspname AS specific_schema,        ss.proname::text AS specific_name,        (ss.x).n AS ordinal_position,        NULLIF(ss.proargnames[(ss.x).n], ''::text) AS parameter_name,        CASE            WHEN t.typelem <> (0)::oid AND t.typlen = (-1)            THEN 'ARRAY'::text            WHEN nt.nspname = 'pg_catalog'::name            THEN format_type(t.oid, NULL::INTEGER)            ELSE 'USER-DEFINED'::text        END AS formatted_type_name,        ss.p_oid AS procedure_oid,        t.typname AS unformatted_type_name,        t.oid AS type_oid   FROM pg_type t,        pg_namespace nt,        (          SELECT n.nspname AS n_nspname,                 p.proname,                 p.oid AS p_oid,                 p.proargnames,                 p.proargmodes,                 information_schema._pg_expandarray(COALESCE(p.proallargtypes, (p.proargtypes)::oid[])) AS x            FROM pg_namespace n,                 pg_proc p           WHERE ((n.oid = p.pronamespace)             AND (pg_has_role(p.proowner, 'USAGE'::text) OR  has_function_privilege(p.oid, 'EXECUTE'::text)))         ) ss WHERE t.oid = (ss.x).x   AND t.typnamespace = nt.oid   AND ss.proargmodes[(ss.x).n] = ANY ('{o,b,t}'::char[]);";
    private Map<String, DbFunction> functions = null;
    private Map<String, List<String>> functionNameToFQName = null;
    private static Map<String, DbFunctionRegister> registers;
    private List<String> searchPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbFunctionRegister(Connection connection) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            this.searchPath = DbTypeRegister.getSearchPath(connection);
            this.functionNameToFQName = new HashMap<String, List<String>>();
            this.functions = new HashMap<String, DbFunction>();
            statement = connection.prepareStatement(FUNCTION_DETAILS);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int i = 1;
                String functionSchema = resultSet.getString(i++);
                String functionName = resultSet.getString(i++);
                int paramPosition = resultSet.getInt(i++);
                String paramName = resultSet.getString(i++);
                String paramType = resultSet.getString(i++);
                int procedureId = resultSet.getInt(i++);
                String paramTypeName = resultSet.getString(i++);
                int paramTypeId = resultSet.getInt(i++);
                this.addFunctionParam(functionSchema, functionName, paramName, paramPosition, paramType, procedureId, paramTypeName, paramTypeId);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void addFunctionParam(String functionSchema, String functionName, String paramName, int paramPosition, String paramType, int procedureId, String paramTypeName, int paramTypeId) {
        String functionId = DbFunctionRegister.getFunctionIdentifier(functionSchema, functionName);
        DbFunction function = this.functions.get(functionId);
        if (function == null) {
            function = new DbFunction(functionSchema, functionName);
            this.addFunction(function);
        }
        if (paramName != null) {
            function.addOutParam(new DbTypeField(paramName, paramPosition, paramType, paramTypeName, paramTypeId));
        }
    }

    private void addFunction(DbFunction function) {
        String functionIdentifier = DbFunctionRegister.getFunctionIdentifier(function.getSchema(), function.getName());
        this.functions.put(functionIdentifier, function);
        List<String> list = this.functionNameToFQName.get(function.getName());
        if (list == null) {
            list = new LinkedList<String>();
            this.functionNameToFQName.put(function.getName(), list);
        }
        list.add(functionIdentifier);
    }

    private static String getFunctionIdentifier(String schema, String functionName) {
        return schema + "." + functionName;
    }

    public static final DbFunction getFunction(String name, Connection connection) throws SQLException {
        if (registers == null) {
            DbFunctionRegister.initRegistry(connection, "default");
        }
        for (DbFunctionRegister register : registers.values()) {
            DbFunction function;
            List<String> list = register.functionNameToFQName.get(name);
            if (list.size() == 1) {
                return register.functions.get(list.get(0));
            }
            String fqName = SearchPathSchemaFilter.filter(list, register.searchPath);
            if (fqName == null || (function = register.functions.get(fqName)) == null) continue;
            return function;
        }
        return null;
    }

    public static synchronized void reInitRegistry(Connection connection) throws SQLException {
        if (registers == null) {
            registers = new HashMap<String, DbFunctionRegister>();
        }
        registers.put("default", new DbFunctionRegister(connection));
    }

    public static synchronized void initRegistry(Connection connection, String name) throws SQLException {
        if (registers == null) {
            registers = new HashMap<String, DbFunctionRegister>();
        }
        if (!registers.containsKey(name)) {
            registers.put(name, new DbFunctionRegister(connection));
        }
    }
}

