/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.result;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.typemapper.core.db.DbType;
import org.zalando.typemapper.core.db.DbTypeField;
import org.zalando.typemapper.core.db.DbTypeRegister;
import org.zalando.typemapper.core.result.ArrayResultNode;
import org.zalando.typemapper.core.result.DbResultNode;
import org.zalando.typemapper.core.result.DbResultNodeType;
import org.zalando.typemapper.core.result.SimpleResultNode;
import org.zalando.typemapper.parser.exception.RowParserException;
import org.zalando.typemapper.parser.postgres.ParseUtils;

public class ObjectResultNode
implements DbResultNode {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectResultNode.class);
    private final String name;
    private final String type;
    private final int typeId;
    private List<DbResultNode> children;
    private final Map<String, DbResultNode> nodeMap = new HashMap<String, DbResultNode>();

    public ObjectResultNode(String value, String name, String typeName, int typeId, Connection connection) throws SQLException {
        List<String> values;
        this.type = typeName;
        this.typeId = typeId;
        this.children = new ArrayList<DbResultNode>();
        this.name = name;
        if (value == null) {
            this.children = null;
            return;
        }
        try {
            values = ParseUtils.postgresROW2StringList(value);
        }
        catch (RowParserException e) {
            throw new SQLException(e);
        }
        DbType dbType = DbTypeRegister.getDbType(typeId, connection);
        int i = 1;
        for (String fieldValue : values) {
            if (dbType == null) {
                String error = "dbType is null for typename: " + typeName;
                LOG.error(error);
                throw new NullPointerException(error);
            }
            DbTypeField fieldDef = dbType.getFieldByPos(i);
            if (fieldDef == null) {
                LOG.error("Could not find field in {} for pos {}", (Object)dbType, (Object)i);
                continue;
            }
            DbResultNode node = fieldDef.getType().equals("USER-DEFINED") ? (fieldDef.getTypeName().equals("hstore") ? new SimpleResultNode(fieldValue, fieldDef.getName()) : (fieldDef.getTypeName().equals("enumeration") ? new SimpleResultNode(fieldValue, fieldDef.getName()) : new ObjectResultNode(fieldValue, fieldDef.getName(), fieldDef.getTypeName(), fieldDef.getTypeId(), connection))) : (fieldDef.getType().equals("ARRAY") ? new ArrayResultNode(fieldDef.getName(), fieldValue, fieldDef.getTypeName().substring(1), fieldDef.getTypeId(), connection) : (fieldDef.getType().equals("enum") ? new SimpleResultNode(fieldValue, this.type) : new SimpleResultNode(fieldValue, fieldDef.getName())));
            this.children.add(node);
            ++i;
        }
    }

    public String getType() {
        return this.type;
    }

    @Override
    public DbResultNodeType getNodeType() {
        return DbResultNodeType.OBJECT;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public List<DbResultNode> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DbResultNode getChildByName(String name) {
        DbResultNode resultNode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Lookup the property value of name {} in the object of the name: {} and type: {}", new Object[]{name, this.name, this.type});
        }
        if ((resultNode = this.nodeMap.get(name)) == null) {
            for (DbResultNode node : this.getChildren()) {
                if (!node.getName().equals(name)) continue;
                resultNode = node;
                this.nodeMap.put(name, resultNode);
                break;
            }
        }
        return resultNode;
    }

    public String toString() {
        return "ObjectResultNode [name=" + this.name + ", type=" + this.type + ", typeId=" + this.typeId + ", children=" + this.children + "]";
    }
}

