/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.typemapper.core.db.DbType;
import org.zalando.typemapper.core.db.DbTypeField;
import org.zalando.typemapper.core.db.SearchPathSchemaFilter;

public class DbTypeRegister {
    private static final Logger LOG = LoggerFactory.getLogger(DbTypeRegister.class);
    private static volatile Map<String, DbTypeRegister> registers = ImmutableMap.of();
    private static final Object typeIdToFQNLock = new Object();
    private static final Object typeRegisterLock = new Object();
    private final Map<String, DbType> typeByName;
    private final List<String> searchPath;
    private final Map<String, String> typeFQN;
    private final Map<Long, String> typeIdToFQN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbTypeRegister(Connection connection) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            this.searchPath = DbTypeRegister.getSearchPath(connection);
            this.typeByName = new HashMap<String, DbType>();
            this.typeIdToFQN = new ConcurrentHashMap<Long, String>();
            HashMap<String, List<String>> typeNameToFQN = new HashMap<String, List<String>>();
            statement = connection.prepareStatement("select tn.nspname as type_schema, t.typname as type_name, t.oid as type_id, t.typtype as type_type, a.attname as att_name, (CASE WHEN ((t2.typelem <> (0)::oid) AND (t2.typlen = -1)) THEN 'ARRAY'::text  WHEN (tn2.nspname = 'pg_catalog'::name) THEN format_type(a.atttypid, NULL::integer) ELSE 'USER-DEFINED'::text END) as att_type, t2.typname, t2.oid, a.attnum as att_position, t.typelem <> 0 AND t.typlen = (-1) as is_array, t.typelem from pg_type as t join pg_namespace as tn on t.typnamespace = tn.oid left join pg_class c on t.typrelid = c.oid left join pg_attribute as a on a.attrelid = t.typrelid and a.attnum > 0 and not a.attisdropped left join pg_type as t2 on a.atttypid = t2.oid left join pg_namespace as tn2 on t2.typnamespace = tn2.oid where (t.typtype = 'e' OR (t.typtype = 'c' AND c.relkind = 'c'::char) OR (t.typelem <> 0 AND  t.typlen = (-1) AND t.typtype = 'b'))and tn.nspname not in ( 'pg_catalog', 'pg_toast', 'information_schema' ) and t.typowner > 0 order by is_array, t.typowner, type_schema, type_name, att_position");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int i = 1;
                String typeSchema = resultSet.getString(i++);
                String typeName = resultSet.getString(i++);
                long typeId = resultSet.getLong(i++);
                String typeType = resultSet.getString(i++);
                String fieldName = resultSet.getString(i++);
                String fieldType = resultSet.getString(i++);
                String fieldTypeName = resultSet.getString(i++);
                long fieldTypeId = resultSet.getLong(i++);
                int fieldPosition = resultSet.getInt(i++);
                boolean isArray = resultSet.getBoolean(i++);
                long typeElem = resultSet.getLong(i++);
                this.addField(typeSchema, typeName, typeId, fieldName, fieldPosition, fieldType, fieldTypeName, fieldTypeId, typeType, isArray, typeNameToFQN, typeElem);
            }
            this.typeFQN = this.buildTypeFQN(typeNameToFQN);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static List<String> getSearchPath(Connection connection) throws SQLException {
        ResultSet searchPathResult = connection.createStatement().executeQuery("show search_path;");
        searchPathResult.next();
        String searchPathStr = searchPathResult.getString(1);
        return Arrays.asList(searchPathStr.split("\\s*,\\s*"));
    }

    public List<String> getSearchPath() {
        return this.searchPath;
    }

    public Map<String, DbType> getTypes() {
        return this.typeByName;
    }

    private void addField(String typeSchema, String typeName, long typeId, String fieldName, int fieldPosition, String fieldType, String fieldTypeName, long fieldTypeId, String typeType, boolean isArray, Map<String, List<String>> typeNameToFQN, long typeElem) {
        if (isArray) {
            String typeFQN = this.typeIdToFQN.get(typeId);
            if (typeFQN == null && (typeFQN = this.typeIdToFQN.get(typeElem)) != null) {
                this.typeIdToFQN.put(typeId, typeFQN);
            }
        } else {
            String typeFQN = DbTypeRegister.getTypeIdentifier(typeSchema, typeName);
            DbType type = this.typeByName.get(typeFQN);
            if (type == null) {
                type = new DbType(typeSchema, typeName, typeId);
                this.addType(type, typeNameToFQN);
            }
            if ("e".equals(typeType)) {
                type.addField(new DbTypeField(typeName, 1, "enum", "enum", fieldTypeId));
            } else if (null != fieldName) {
                type.addField(new DbTypeField(fieldName, fieldPosition, fieldType, fieldTypeName, fieldTypeId));
            } else {
                LOG.warn("{}.{} has no attributes!", (Object)typeSchema, (Object)typeName);
            }
        }
    }

    private void addType(DbType type, Map<String, List<String>> typeNameToFQN) {
        String id = DbTypeRegister.getTypeIdentifier(type.getSchema(), type.getName());
        this.typeByName.put(id, type);
        this.typeIdToFQN.put(type.getId(), id);
        List<String> list = typeNameToFQN.get(type.getName());
        if (list == null) {
            list = new LinkedList<String>();
            typeNameToFQN.put(type.getName(), list);
        }
        list.add(id);
    }

    private Map<String, String> buildTypeFQN(Map<String, List<String>> typeNameToFQN) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> entry : typeNameToFQN.entrySet()) {
            List<String> types = entry.getValue();
            String fqn = types.size() == 1 ? types.get(0) : SearchPathSchemaFilter.filter(types, this.searchPath);
            if (fqn == null) continue;
            result.put((Object)entry.getKey(), (Object)fqn);
        }
        return result.build();
    }

    public static String getTypeIdentifier(String typeSchema, String typeName) {
        return typeSchema + "." + typeName;
    }

    public static DbType getDbType(String name, Connection connection) throws SQLException {
        DbTypeRegister register = DbTypeRegister.getRegistry(connection);
        String fqName = register.typeFQN.get(name);
        return fqName == null ? null : register.typeByName.get(fqName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbType getDbType(long id, Connection connection) throws SQLException {
        DbTypeRegister register = DbTypeRegister.getRegistry(connection);
        DbType type = null;
        String typeFQN = register.typeIdToFQN.get(id);
        if (typeFQN == null) {
            boolean load = false;
            Object object = typeIdToFQNLock;
            synchronized (object) {
                typeFQN = register.typeIdToFQN.get(id);
                if (typeFQN == null) {
                    load = true;
                    String sql = "          SELECT tn.nspname AS type_schema ,           (CASE                WHEN t2.typname IS NULL                THEN t.typname                ELSE t2.typname            END) AS type_name      FROM pg_type AS t      JOIN pg_namespace AS tn ON t.typnamespace = tn.oid LEFT JOIN pg_type AS t2 ON t.typelem <> 0 AND t.typlen = (-1) AND t.typelem = t2.oid     WHERE t.oid = ?";
                    ResultSet res = null;
                    PreparedStatement ps = null;
                    try {
                        ps = connection.prepareStatement("          SELECT tn.nspname AS type_schema ,           (CASE                WHEN t2.typname IS NULL                THEN t.typname                ELSE t2.typname            END) AS type_name      FROM pg_type AS t      JOIN pg_namespace AS tn ON t.typnamespace = tn.oid LEFT JOIN pg_type AS t2 ON t.typelem <> 0 AND t.typlen = (-1) AND t.typelem = t2.oid     WHERE t.oid = ?");
                        ps.setLong(1, id);
                        res = ps.executeQuery();
                        if (res.next()) {
                            typeFQN = DbTypeRegister.getTypeIdentifier(res.getString(1), res.getString(2));
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    if (typeFQN != null) {
                        register.typeIdToFQN.put(id, typeFQN);
                    }
                }
            }
            if (load) {
                LOG.info("Type with oid {} not found in local cache.", (Object)id);
            }
        }
        if (typeFQN != null) {
            type = register.typeByName.get(typeFQN);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbTypeRegister getRegistry(Connection connection) throws SQLException {
        Preconditions.checkNotNull((Object)connection);
        String connectionURL = connection.getMetaData().getURL();
        Preconditions.checkNotNull((Object)connection.getMetaData().getURL(), (Object)"connection URL is null");
        DbTypeRegister cachedRegisters = registers.get(connectionURL);
        if (cachedRegisters == null) {
            Object object = typeRegisterLock;
            synchronized (object) {
                cachedRegisters = registers.get(connectionURL);
                if (cachedRegisters == null) {
                    cachedRegisters = new DbTypeRegister(connection);
                    registers = ImmutableMap.builder().putAll(registers).put((Object)connectionURL, (Object)cachedRegisters).build();
                }
            }
        }
        return cachedRegisters;
    }

    public static void reInitRegister(Connection connection) throws SQLException {
        registers = ImmutableMap.of((Object)connection.getMetaData().getURL(), (Object)new DbTypeRegister(connection));
    }
}

