/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.parser.postgres;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.typemapper.parser.exception.RowParserException;
import org.zalando.typemapper.parser.postgres.Element;
import org.zalando.typemapper.parser.postgres.ParseUtils;

public class RowMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RowMapper.class);

    public final Element mapRow(ResultSet rs, String columnName) throws SQLException {
        List<String> l;
        Element element = new Element();
        try {
            l = ParseUtils.postgresROW2StringList(rs.getString(columnName));
        }
        catch (RowParserException e) {
            throw new SQLException(e);
        }
        element.setRowList(l);
        return element;
    }

    public final List<Element> mapRowToList(ResultSet rs, String columnNameArray) throws SQLException {
        if (rs == null) {
            return Collections.emptyList();
        }
        Array sqlArray = rs.getArray(columnNameArray);
        if (sqlArray == null) {
            return Collections.emptyList();
        }
        ResultSet resultSet = sqlArray.getResultSet();
        ArrayList<String> l = new ArrayList<String>();
        while (resultSet.next()) {
            String test = resultSet.getString(2);
            l.add(test);
        }
        ArrayList<Element> elements = new ArrayList<Element>(l.size());
        for (String s : l) {
            try {
                List<String> resultList = ParseUtils.postgresROW2StringList(s);
                Element element = new Element();
                element.setRowList(resultList);
                elements.add(element);
            }
            catch (Exception e) {
                LOG.error("Problem parsing received ROW value [{}]: {}", new Object[]{s, e.getMessage(), e});
            }
        }
        return elements;
    }
}

