/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.postgres;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.postgresql.util.PGobject;
import org.zalando.typemapper.postgres.AbstractPgCollectionSerializer;
import org.zalando.typemapper.postgres.PgTypeHelper;

public final class PgRow
extends PGobject {
    private static final long serialVersionUID = -2855096142894174113L;
    private final PgRowSerializer serializer;

    protected PgRow(String recordTypeName, Collection<Object> c) throws SQLException {
        this.serializer = new PgRowSerializer(c);
        this.setType(recordTypeName);
        this.setValue(this.serializer.toString());
    }

    public PgRow(PgTypeHelper.PgTypeDataHolder typeDataHolder) throws SQLException {
        this(typeDataHolder.getTypeName(), typeDataHolder.getAttributes());
    }

    public PgRow(PgTypeHelper.PgTypeDataHolder typeDataHolder, Connection connection) throws SQLException {
        this.serializer = new PgRowSerializer(typeDataHolder.getAttributes());
        this.setType(typeDataHolder.getTypeName());
        this.setValue(this.serializer.toString(connection));
    }

    public static PgRow ROW(Object ... array) throws SQLException {
        return new PgRow("unknownType", array == null ? null : Arrays.asList(array));
    }

    public static PgRow ROW(Collection<?> collection) throws SQLException {
        return new PgRow("unknownType", collection);
    }

    public String toString() {
        return this.serializer.toString();
    }

    public PGobject asPGobject(String recordTypeName) throws SQLException {
        this.setType(recordTypeName);
        return this;
    }

    private final class PgRowSerializer
    extends AbstractPgCollectionSerializer<Object> {
        protected PgRowSerializer(Collection<Object> c) {
            super(c);
        }

        @Override
        protected char getOpeningChar() {
            return '(';
        }

        @Override
        protected char getClosingChar() {
            return ')';
        }

        @Override
        protected void quoteChar(StringBuilder sb, char ch) {
            sb.append(ch).append(ch);
        }

        @Override
        protected void appendNull(StringBuilder sb) {
        }
    }
}

