/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper;

import com.google.common.base.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@Inherited
public @interface SProcCall {
    public String name() default "";

    public String sql() default "";

    public Class<?> shardStrategy() default Void.class;

    public boolean runOnAllShards() default false;

    public boolean searchShards() default false;

    public boolean parallel() default false;

    public boolean readOnly() default true;

    public WriteTransaction shardedWriteTransaction() default WriteTransaction.USE_FROM_SERVICE;

    public Class<?> resultMapper() default Void.class;

    public long timeoutInMilliSeconds() default 0L;

    public long adivsoryLockId() default 0L;

    public String adivsoryLockName() default "NO_LOCK";

    public Validate validate() default Validate.AS_DEFINED_IN_SERVICE;

    public static enum WriteTransaction {
        USE_FROM_SERVICE,
        NONE,
        ONE_PHASE,
        TWO_PHASE;

    }

    public static enum Validate {
        AS_DEFINED_IN_SERVICE,
        YES,
        NO;

    }

    public static class AdvisoryLock {
        private final String name;
        private final long lockId;

        public AdvisoryLock(String name, long lockId) {
            Preconditions.checkNotNull((Object)name, (Object)"Name parameter cannot be null.");
            Preconditions.checkArgument((lockId == 0L && Objects.equals(name, "NO_LOCK") || lockId != 0L && !Objects.equals(name, "NO_LOCK") ? 1 : 0) != 0, (String)"LockId parameter is different than %s (%s) but the name parameter was not changed: [name: %s, lockId: %s]", (Object)0L, (Object)"NO_LOCK", (Object)name, (Object)lockId);
            this.name = name;
            this.lockId = lockId;
        }

        public String getName() {
            return this.name;
        }

        public long getLockId() {
            return this.lockId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdvisoryLock that = (AdvisoryLock)o;
            if (this.lockId != that.lockId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (int)(this.lockId ^ this.lockId >>> 32);
            return result;
        }

        public String toString() {
            return "AdvisoryLock{name='" + this.name + '\'' + ", lockId=" + this.lockId + '}';
        }

        public static class LockOne {
            public static final String NAME = "LOCK_ONE";
            public static final long LOCK_ID = 1L;
            public static final AdvisoryLock LOCK = new AdvisoryLock("LOCK_ONE", 1L);
        }

        public static class NoLock {
            public static final String NAME = "NO_LOCK";
            public static final long LOCK_ID = 0L;
            public static final AdvisoryLock LOCK = new AdvisoryLock("NO_LOCK", 0L);
        }
    }
}

