/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.dsprovider;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.zalando.sprocwrapper.dsprovider.DataSourceProvider;

public class ArrayDataSourceProvider
implements DataSourceProvider {
    private final DataSource[] dss;

    public ArrayDataSourceProvider(DataSource[] ds) {
        this.dss = ds;
    }

    @Override
    public int getDataSourceId(int virtualShardId) {
        return virtualShardId % this.dss.length;
    }

    @Override
    public DataSource getDataSource(int virtualShardId) {
        return this.dss[virtualShardId % this.dss.length];
    }

    @Override
    public List<Integer> getDistinctShardIds() {
        ArrayList shardIds = Lists.newArrayListWithExpectedSize((int)this.dss.length);
        for (int i = 0; i < this.dss.length; ++i) {
            shardIds.add(i);
        }
        return shardIds;
    }
}

