/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.globalvaluetransformer;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.globalvaluetransformer.ValueTransformerUtils;
import org.zalando.sprocwrapper.globalvaluetransformer.annotation.GlobalValueTransformer;
import org.zalando.typemapper.core.ValueTransformer;
import org.zalando.typemapper.core.fieldMapper.GlobalValueTransformerRegistry;

public class GlobalValueTransformerLoader {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalValueTransformerLoader.class);
    private static final String GLOBAL_VALUE_TRANSFORMER_SEARCH_NAMESPACE = "global.value.transformer.search.namespace";
    private static final String NAMESPACE_SEPARATOR = ";";
    private static String namespaceToScan = "org.zalando";
    private static boolean scannedClasspath = false;

    public static synchronized ValueTransformer<?, ?> getValueTransformerForClass(Class<?> genericType) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (!scannedClasspath) {
            String myNameSpaceToScan = null;
            try {
                myNameSpaceToScan = System.getenv(GLOBAL_VALUE_TRANSFORMER_SEARCH_NAMESPACE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Strings.isNullOrEmpty((String)myNameSpaceToScan)) {
                myNameSpaceToScan = namespaceToScan;
            }
            Set<String> namespaces = GlobalValueTransformerLoader.parseNamespaces(myNameSpaceToScan);
            namespaces.add(namespaceToScan);
            LOG.debug("Scan the following packages for {}: {}", (Object)GlobalValueTransformer.class.getSimpleName(), namespaces);
            Set<Class<?>> typesAnnotatedWith = GlobalValueTransformerLoader.loadAnnotatedTypes(namespaces);
            for (Class<?> foundGlobalValueTransformer : typesAnnotatedWith) {
                Class<?> valueTransformerReturnType;
                try {
                    valueTransformerReturnType = ValueTransformerUtils.getUnmarshalFromDbClass(foundGlobalValueTransformer);
                    GlobalValueTransformerRegistry.register(valueTransformerReturnType, (ValueTransformer)foundGlobalValueTransformer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (RuntimeException e) {
                    LOG.error("Failed to add global transformer [{}] to global registry.", foundGlobalValueTransformer, (Object)e);
                    continue;
                }
                LOG.debug("Global Value Transformer [{}] for type [{}] registered.", (Object)foundGlobalValueTransformer.getSimpleName(), (Object)valueTransformerReturnType.getSimpleName());
            }
            scannedClasspath = true;
        }
        return GlobalValueTransformerRegistry.getValueTransformerForClass(genericType);
    }

    private static Set<Class<?>> loadAnnotatedTypes(Set<String> namespacesToScan) {
        Predicate filter = input -> GlobalValueTransformer.class.getCanonicalName().equals(input);
        HashSet result = new HashSet();
        for (String namespace : namespacesToScan) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)namespace))).setUrls(ClasspathHelper.forPackage((String)namespace, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new TypeAnnotationsScanner().filterResultsBy(filter), new SubTypesScanner()}));
            result.addAll(reflections.getTypesAnnotatedWith(GlobalValueTransformer.class));
        }
        return result;
    }

    public static void changeNamespaceToScan(String newNamespace) {
        namespaceToScan = newNamespace;
        scannedClasspath = false;
    }

    static Set<String> parseNamespaces(String inputString) {
        return Arrays.stream(inputString.split(NAMESPACE_SEPARATOR)).map(String::trim).filter(ns -> !Strings.isNullOrEmpty((String)ns)).collect(Collectors.toSet());
    }
}

