/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.globalvaluetransformer;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.zalando.typemapper.core.ValueTransformer;

public final class ValueTransformerUtils {
    private ValueTransformerUtils() {
    }

    public static Class<?> getMarshalToDbClass(ValueTransformer<?, ?> valueTransformer) {
        return ValueTransformerUtils.resolveReturnType(valueTransformer.getClass(), "marshalToDb", Object.class);
    }

    public static Class<?> getUnmarshalFromDbClass(Class<?> clazz) {
        return ValueTransformerUtils.resolveReturnType(ValueTransformerUtils.checkValueTransformerClass(clazz), "unmarshalFromDb", String.class);
    }

    private static <T extends ValueTransformer<?, ?>> Class<?> resolveReturnType(Class<T> actualClass, String methodName, Class<?> ... methodParameterTypes) {
        Method valueTransformerMethod = ValueTransformerUtils.findValueTransformerMethod(methodName, methodParameterTypes);
        Type genericReturnType = valueTransformerMethod.getGenericReturnType();
        return TypeToken.of(actualClass).resolveType(genericReturnType).getRawType();
    }

    private static Method findValueTransformerMethod(String name, Class<?> ... parameterTypes) {
        try {
            return ValueTransformer.class.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("couldn't locate ValueTransformer method " + name, e);
        }
    }

    private static Class<? extends ValueTransformer<?, ?>> checkValueTransformerClass(Class<?> clazz) {
        Preconditions.checkArgument((boolean)ValueTransformer.class.isAssignableFrom(clazz), (String)"not a ValueTransformer: %s", clazz);
        return clazz;
    }
}

