/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Array;
import java.sql.Connection;
import java.util.Collection;
import org.zalando.sprocwrapper.proxy.StoredProcedureParameter;
import org.zalando.sprocwrapper.util.NameUtils;
import org.zalando.typemapper.annotations.DatabaseType;
import org.zalando.typemapper.postgres.PgArray;
import org.zalando.typemapper.postgres.PgTypeHelper;

class ArrayStoredProcedureParameter
extends StoredProcedureParameter {
    protected String innerTypeName = null;

    public ArrayStoredProcedureParameter(Class<?> clazz, Method m, String typeName, int sqlType, int javaPosition, boolean sensitive) {
        super(clazz, m, typeName, sqlType, javaPosition, sensitive);
        if (typeName != null && typeName.endsWith("[]")) {
            this.innerTypeName = typeName.substring(0, typeName.length() - 2);
        } else {
            if (typeName != null && !"".equals(typeName)) {
                throw new IllegalArgumentException("SprocService-Param: [" + clazz.getName() + ", " + m.getName() + "] Provided typename must end with [] in case of list parameters: " + typeName);
            }
            Type parameterType = m.getGenericParameterTypes()[javaPosition];
            if (!(parameterType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("SprocService-Param: [" + clazz.getName() + ", " + m.getName() + "] Parameter must be of type Parametrized List<?> but is: " + parameterType.toString());
            }
            ParameterizedType p = (ParameterizedType)parameterType;
            Class paramsClass = (Class)p.getActualTypeArguments()[0];
            this.innerTypeName = PgTypeHelper.getSQLNameForClass(paramsClass);
            if (this.innerTypeName == null) {
                DatabaseType dbType = paramsClass.getAnnotation(DatabaseType.class);
                if (dbType != null) {
                    this.innerTypeName = dbType.name();
                }
                if (this.innerTypeName == null || this.innerTypeName.isEmpty()) {
                    this.innerTypeName = NameUtils.camelCaseToUnderscore(paramsClass.getSimpleName());
                }
            }
        }
    }

    @Override
    public Object mapParam(Object value, Connection connection) {
        if (value == null) {
            return null;
        }
        Array result = value;
        result = PgArray.ARRAY((Collection)((Object)value));
        if (this.innerTypeName != null) {
            result = result.asJdbcArray(this.innerTypeName, connection);
        }
        return result;
    }
}

