/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.zalando.sprocwrapper.globalvaluetransformer.ValueTransformerUtils;
import org.zalando.sprocwrapper.proxy.ArrayStoredProcedureParameter;
import org.zalando.sprocwrapper.proxy.StoredProcedureParameter;
import org.zalando.typemapper.core.ValueTransformer;
import org.zalando.typemapper.core.fieldMapper.ObjectMapper;
import org.zalando.typemapper.postgres.PgTypeHelper;

public class GlobalValueTransformedParameter
extends StoredProcedureParameter {
    private final StoredProcedureParameter forwardingStoredProcedureParameter;
    private final ValueTransformer<?, ?> valueTransformerForClass;
    private final ObjectMapper<?> globalObjectMapper;

    public GlobalValueTransformedParameter(ValueTransformer<?, ?> valueTransformerForClass, Class<?> clazz, Method m, String typeName, int javaPosition, boolean sensitive, ObjectMapper<?> globalObjectMapper) throws InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, IllegalArgumentException, NoSuchMethodException {
        super(GlobalValueTransformedParameter.getValueTransformedClazz(clazz, valueTransformerForClass), m, typeName, GlobalValueTransformedParameter.getValueTransformedTypeId(clazz), javaPosition, sensitive);
        this.valueTransformerForClass = valueTransformerForClass;
        this.globalObjectMapper = globalObjectMapper;
        this.forwardingStoredProcedureParameter = GlobalValueTransformedParameter.createParameter(GlobalValueTransformedParameter.getValueTransformedClazz(clazz, valueTransformerForClass), this.getValueTransformedGenericClass(clazz), m, this.getValueTransformedTypeName(clazz, valueTransformerForClass), GlobalValueTransformedParameter.getValueTransformedTypeId(clazz), javaPosition, sensitive);
    }

    @Override
    public Object mapParam(Object value, Connection connection) {
        if (value == null) {
            return this.forwardingStoredProcedureParameter.mapParam(value, connection);
        }
        if (this.forwardingStoredProcedureParameter instanceof ArrayStoredProcedureParameter) {
            ArrayList transformedValues = Lists.newArrayList();
            if (value.getClass().isArray()) {
                for (Object o : (Object[])value) {
                    transformedValues.add(this.getMarshaledObject(o));
                }
            } else {
                for (Object o : (Collection)value) {
                    transformedValues.add(String.valueOf(this.getMarshaledObject(o)));
                }
            }
            return this.forwardingStoredProcedureParameter.mapParam(transformedValues, connection);
        }
        return this.forwardingStoredProcedureParameter.mapParam(this.getMarshaledObject(value), connection);
    }

    private Object getMarshaledObject(Object o) {
        if (this.globalObjectMapper != null) {
            return this.globalObjectMapper.marshalToDb(o);
        }
        return this.valueTransformerForClass.marshalToDb(o);
    }

    @Override
    public int getJavaPos() {
        return this.forwardingStoredProcedureParameter.getJavaPos();
    }

    @Override
    public boolean isSensitive() {
        return this.forwardingStoredProcedureParameter.isSensitive();
    }

    @Override
    public int getType() {
        return this.forwardingStoredProcedureParameter.getType();
    }

    @Override
    public String getTypeName() {
        return this.forwardingStoredProcedureParameter.getTypeName();
    }

    private static int getValueTransformedTypeId(Class<?> clazz) {
        return -1;
    }

    private String getValueTransformedTypeName(Class<?> clazz, ValueTransformer<?, ?> valueTransformerForClass) {
        Class<?> valueTransformedGenericClass = this.getValueTransformedGenericClass(valueTransformerForClass.getClass());
        String sqlNameForClass = PgTypeHelper.getSQLNameForClass(valueTransformedGenericClass);
        if (sqlNameForClass != null && clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            sqlNameForClass = sqlNameForClass + "[]";
        }
        return sqlNameForClass;
    }

    private static Class<?> getValueTransformedClazz(Class<?> clazz, ValueTransformer<?, ?> valueTransformerForClass) {
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            return List.class;
        }
        return ValueTransformerUtils.getMarshalToDbClass(valueTransformerForClass);
    }

    private Class<?> getValueTransformedGenericClass(Class<?> clazz) {
        return ValueTransformerUtils.getMarshalToDbClass(this.valueTransformerForClass);
    }
}

