/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.proxy.StoredProcedureParameter;
import org.zalando.typemapper.postgres.PgTypeHelper;

class OtherStoredProcedureParameter
extends StoredProcedureParameter {
    private static final Logger LOG = LoggerFactory.getLogger(OtherStoredProcedureParameter.class);

    public OtherStoredProcedureParameter(Class<?> clazz, Method m, String typeName, int sqlType, int javaPosition, boolean sensitive) {
        super(clazz, m, typeName, sqlType, javaPosition, sensitive);
    }

    @Override
    public Object mapParam(Object value, Connection connection) {
        Object result;
        block15: {
            if (value == null) {
                if (this.clazz.isEnum()) {
                    PGobject pgobj = new PGobject();
                    pgobj.setType(this.typeName);
                    return pgobj;
                }
                return null;
            }
            result = value;
            if (this.clazz.isEnum()) {
                PGobject pgobj = new PGobject();
                pgobj.setType(this.typeName);
                try {
                    pgobj.setValue(((Enum)value).name());
                }
                catch (SQLException ex) {
                    if (this.sensitive) {
                        LOG.error("Failed to set PG object value (sensitive parameter, stacktrace hidden)");
                    }
                    LOG.error("Failed to set PG object value", (Throwable)ex);
                }
                result = pgobj;
            } else if (this.clazz.isAssignableFrom(UUID.class)) {
                PGobject pgobj = new PGobject();
                pgobj.setType(this.typeName);
                try {
                    pgobj.setValue(value.toString());
                }
                catch (SQLException ex) {
                    if (this.sensitive) {
                        LOG.error("Failed to set PG object value (sensitive parameter, stacktrace hidden)");
                        break block15;
                    }
                    LOG.error("Failed to set PG object value", (Throwable)ex);
                }
            } else {
                try {
                    result = PgTypeHelper.asPGobject(value, this.typeName, connection);
                }
                catch (SQLException ex) {
                    if (this.sensitive) {
                        LOG.error("Failed to serialize PG object (sensitive parameter, stacktrace hidden)");
                    }
                    LOG.error("Failed to serialize PG object", (Throwable)ex);
                }
            }
        }
        return result;
    }
}

