/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.zalando.sprocwrapper.SProcCall;
import org.zalando.sprocwrapper.SProcParam;
import org.zalando.sprocwrapper.SProcService;
import org.zalando.sprocwrapper.proxy.SProcServiceAnnotationHandler;
import org.zalando.sprocwrapper.proxy.ShardKeyParameter;
import org.zalando.sprocwrapper.proxy.StoredProcedure;
import org.zalando.sprocwrapper.proxy.StoredProcedureParameter;
import org.zalando.sprocwrapper.sharding.ShardKey;
import org.zalando.sprocwrapper.sharding.VirtualShardKeyStrategy;
import org.zalando.sprocwrapper.util.NameUtils;

public class SProcCallHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SProcCallHandler.class);

    private static String getSqlNameForMethod(String methodName) {
        return NameUtils.camelCaseToUnderscore(methodName);
    }

    List<Method> findSProcCallAnnotatedMethods(Class c) {
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (Method method : c.getMethods()) {
            if (!method.isAnnotationPresent(SProcCall.class)) continue;
            foundMethods.add(method);
        }
        return foundMethods;
    }

    private RowMapper getRowMapper(SProcCall scA) {
        if (scA.resultMapper() != Void.class) {
            try {
                return (RowMapper)scA.resultMapper().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                LOG.error("Result mapper for sproc can not be instantiated", (Throwable)ex);
                throw new IllegalArgumentException("Result mapper for sproc can not be instantiated");
            }
        }
        return null;
    }

    private boolean isValidationActive(SProcCall scA, SProcServiceAnnotationHandler.HandlerResult handlerResult) {
        boolean result = handlerResult.isValidationActive();
        if (scA.validate() == SProcCall.Validate.YES) {
            result = true;
        } else if (scA.validate() == SProcCall.Validate.NO) {
            result = false;
        }
        return result;
    }

    public static SProcService.WriteTransaction mapSprocWriteTransactionToServiceWriteTransaction(SProcCall.WriteTransaction scWiWriteTransaction, SProcServiceAnnotationHandler.HandlerResult handlerResult) {
        SProcService.WriteTransaction serviceWriteTransaction = handlerResult.getWriteTransaction();
        if (scWiWriteTransaction == null) {
            throw new IllegalArgumentException("scWiWriteTransaction cannot be null");
        }
        switch (scWiWriteTransaction) {
            case NONE: {
                serviceWriteTransaction = SProcService.WriteTransaction.NONE;
                break;
            }
            case ONE_PHASE: {
                serviceWriteTransaction = SProcService.WriteTransaction.ONE_PHASE;
                break;
            }
            case TWO_PHASE: {
                serviceWriteTransaction = SProcService.WriteTransaction.TWO_PHASE;
                break;
            }
            default: {
                if (serviceWriteTransaction != null) break;
                throw new IllegalArgumentException("ServiceWriteTransaction cannot be null");
            }
        }
        return serviceWriteTransaction;
    }

    public Map<Method, StoredProcedure> handle(Class c, SProcServiceAnnotationHandler.HandlerResult handlerResult) {
        if (handlerResult == null) {
            throw new IllegalArgumentException("handlerResult should not be null");
        }
        if (c == null) {
            throw new IllegalArgumentException("class should not be null");
        }
        HashMap<Method, StoredProcedure> result = new HashMap<Method, StoredProcedure>();
        List<Method> annotatedMethods = this.findSProcCallAnnotatedMethods(c);
        for (Method method : annotatedMethods) {
            SProcCall scA = method.getAnnotation(SProcCall.class);
            String name = scA.name();
            if ("".equals(name)) {
                name = SProcCallHandler.getSqlNameForMethod(method.getName());
            }
            name = handlerResult.getPrefix() + name;
            VirtualShardKeyStrategy sprocStrategy = handlerResult.getShardKeyStrategy();
            if (scA.shardStrategy() != Void.class) {
                try {
                    sprocStrategy = (VirtualShardKeyStrategy)scA.shardStrategy().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    LOG.error("Shard strategy for sproc can not be instantiated", (Throwable)ex);
                    throw new IllegalArgumentException("Shard strategy for sproc can not be instantiated");
                }
            }
            RowMapper resultMapper = this.getRowMapper(scA);
            boolean useValidation = this.isValidationActive(scA, handlerResult);
            ArrayList<ShardKeyParameter> shardKeyParameters = new ArrayList<ShardKeyParameter>();
            ArrayList<StoredProcedureParameter> params = new ArrayList<StoredProcedureParameter>();
            int pos = 0;
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] as;
                for (Annotation a : as = annotationArray[i]) {
                    ParameterizedType parameterizedType;
                    Class<?> clazz = method.getParameterTypes()[pos];
                    Type genericType = method.getGenericParameterTypes()[pos];
                    if (genericType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments() != null && parameterizedType.getActualTypeArguments().length > 0) {
                        genericType = parameterizedType.getActualTypeArguments()[0];
                    }
                    if (a instanceof ShardKey) {
                        shardKeyParameters.add(new ShardKeyParameter(pos, clazz));
                    }
                    if (!(a instanceof SProcParam)) continue;
                    SProcParam sParam = (SProcParam)a;
                    String dbTypeName = sParam.type();
                    try {
                        params.add(StoredProcedureParameter.createParameter(clazz, genericType, method, dbTypeName, sParam.sqlType(), pos, sParam.sensitive()));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        LOG.error("Could not instantiate StoredProcedureParameter. ABORTING.", (Throwable)e);
                        throw new IllegalArgumentException("Could not instantiate StoredProcedureParameter. ABORTING.");
                    }
                }
                ++pos;
            }
            StoredProcedure storedProcedure = this.createStoredProcedure(scA, handlerResult, method, name, params, sprocStrategy, shardKeyParameters, resultMapper, useValidation);
            result.put(method, storedProcedure);
        }
        return result;
    }

    private StoredProcedure createStoredProcedure(SProcCall scA, SProcServiceAnnotationHandler.HandlerResult handlerResult, Method method, String name, List<StoredProcedureParameter> params, VirtualShardKeyStrategy sprocStrategy, List<ShardKeyParameter> shardKeyParameters, RowMapper<?> resultMapper, boolean useValidation) {
        try {
            SProcService.WriteTransaction writeTransaction = SProcCallHandler.mapSprocWriteTransactionToServiceWriteTransaction(scA.shardedWriteTransaction(), handlerResult);
            String query = !"".equals(scA.sql()) ? scA.sql() : null;
            StoredProcedure storedProcedure = new StoredProcedure(name, query, params, method.getGenericReturnType(), sprocStrategy, shardKeyParameters, scA.runOnAllShards(), scA.searchShards(), scA.parallel(), resultMapper, scA.timeoutInMilliSeconds(), new SProcCall.AdvisoryLock(scA.adivsoryLockName(), scA.adivsoryLockId()), useValidation, scA.readOnly(), writeTransaction);
            return storedProcedure;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error("Could not instantiate StoredProcedure. ABORTING.", (Throwable)e);
            throw new IllegalArgumentException("Could not instantiate StoredProcedure. ABORTING.");
        }
    }
}

