/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.dsprovider.DataSourceProvider;
import org.zalando.sprocwrapper.proxy.SProcCallHandler;
import org.zalando.sprocwrapper.proxy.SProcProxy;
import org.zalando.sprocwrapper.proxy.SProcServiceAnnotationHandler;
import org.zalando.sprocwrapper.proxy.StoredProcedure;

public class SProcProxyBuilder {
    private static SProcServiceAnnotationHandler sProcServiceAnnotationHandler = new SProcServiceAnnotationHandler();
    private static SProcCallHandler sProcCallHandler = new SProcCallHandler();
    private static final Logger LOG = LoggerFactory.getLogger(SProcProxyBuilder.class);

    private SProcProxyBuilder() {
    }

    public static <T> T build(DataSourceProvider d, Class<T> c) {
        SProcProxy proxy = new SProcProxy(d, c.getName());
        try {
            SProcServiceAnnotationHandler.HandlerResult handlerResult = sProcServiceAnnotationHandler.handle(c);
            Map<Method, StoredProcedure> spMap = sProcCallHandler.handle(c, handlerResult);
            for (Method method : spMap.keySet()) {
                StoredProcedure storedProcedure = spMap.get(method);
                LOG.debug("{} registering {}", (Object)c.getSimpleName(), (Object)storedProcedure);
                proxy.addStoredProcedure(method, storedProcedure);
            }
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)((Object)proxy));
    }
}

