/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy.executors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.proxy.InvocationContext;
import org.zalando.sprocwrapper.proxy.executors.Executor;
import org.zalando.typemapper.core.ValueTransformer;
import org.zalando.typemapper.core.fieldMapper.GlobalValueTransformerRegistry;

public class GlobalTransformerExecutorWrapper
implements Executor {
    private final Executor originalExecutor;
    private static final Logger LOG = LoggerFactory.getLogger(GlobalTransformerExecutorWrapper.class);

    public GlobalTransformerExecutorWrapper(Executor e) {
        this.originalExecutor = e;
    }

    @Override
    public Object executeSProc(DataSource ds, String sql, Object[] args, int[] types, InvocationContext invocationContext, Class<?> returnType) {
        Object result = this.originalExecutor.executeSProc(ds, sql, args, types, invocationContext, String.class);
        if (result == null) {
            return null;
        }
        ValueTransformer<?, ?> valueTransformerForClass = GlobalValueTransformerRegistry.getValueTransformerForClass(returnType);
        if (valueTransformerForClass != null) {
            if (Collection.class.isAssignableFrom(result.getClass())) {
                ArrayList ret = Lists.newArrayList();
                for (Object o : (Collection)result) {
                    ret.add(valueTransformerForClass.unmarshalFromDb((String)o));
                }
                return ret;
            }
            return valueTransformerForClass.unmarshalFromDb((String)result);
        }
        LOG.error("Could not find a global value transformer for type [{}]. RETURNING NULL instead of transformed [{}] value.", returnType, result);
        return null;
    }
}

