/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy.executors;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.postgresql.util.PGobject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.zalando.sprocwrapper.proxy.InvocationContext;
import org.zalando.sprocwrapper.proxy.executors.Executor;

public class SingleRowSimpleTypeExecutor
implements Executor {
    public static final Map<Class, Class> SIMPLE_TYPES = new HashMap<Class, Class>();

    public static Class<?> mapReturnType(Class<?> returnType) {
        Class clazz = SIMPLE_TYPES.get(returnType);
        if (clazz != null) {
            return clazz;
        }
        return returnType;
    }

    @Override
    public Object executeSProc(DataSource ds, String sql, Object[] args, int[] types, InvocationContext invocationContext, Class<?> returnType) {
        return new JdbcTemplate(ds).queryForObject(sql, args, types, SingleRowSimpleTypeExecutor.mapReturnType(returnType));
    }

    static {
        SIMPLE_TYPES.put(Void.class, PGobject.class);
        SIMPLE_TYPES.put(Void.TYPE, PGobject.class);
        SIMPLE_TYPES.put(Integer.class, Integer.class);
        SIMPLE_TYPES.put(Short.class, Short.class);
        SIMPLE_TYPES.put(String.class, String.class);
        SIMPLE_TYPES.put(Float.class, Float.class);
        SIMPLE_TYPES.put(Double.class, Double.class);
        SIMPLE_TYPES.put(Long.class, Long.class);
        SIMPLE_TYPES.put(Boolean.class, Boolean.class);
        SIMPLE_TYPES.put(Integer.TYPE, Integer.class);
        SIMPLE_TYPES.put(Long.TYPE, Long.class);
        SIMPLE_TYPES.put(Short.TYPE, Short.class);
        SIMPLE_TYPES.put(Float.TYPE, Float.class);
        SIMPLE_TYPES.put(Double.TYPE, Double.class);
        SIMPLE_TYPES.put(Boolean.TYPE, Boolean.class);
        SIMPLE_TYPES.put(Date.class, Date.class);
        SIMPLE_TYPES.put(Timestamp.class, Timestamp.class);
    }
}

