/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy.executors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.SProcCall;
import org.zalando.sprocwrapper.dsprovider.SameConnectionDatasource;
import org.zalando.sprocwrapper.proxy.InvocationContext;
import org.zalando.sprocwrapper.proxy.executors.Executor;

public class ExecutorWrapper
implements Executor {
    private final Executor executor;
    private final long timeoutInMilliSeconds;
    private final SProcCall.AdvisoryLock lock;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorWrapper.class);

    public ExecutorWrapper(Executor e, long t, SProcCall.AdvisoryLock a) {
        this.executor = e;
        this.timeoutInMilliSeconds = t;
        this.lock = a;
    }

    private void setTimeout(Connection conn) throws SQLException {
        if (this.timeoutInMilliSeconds <= 0L) {
            return;
        }
        LOG.debug("Setting statement timeout {}", (Object)this.timeoutInMilliSeconds);
        Statement st = conn.createStatement();
        st.execute("SET application_name TO 'timeout:" + this.timeoutInMilliSeconds + "'");
        st.execute("SET statement_timeout TO " + this.timeoutInMilliSeconds);
        st.close();
    }

    private void resetTimeout(Connection conn) throws SQLException {
        if (this.timeoutInMilliSeconds <= 0L) {
            return;
        }
        LOG.debug("Resetting statement timeout");
        Statement st = conn.createStatement();
        st.execute("RESET statement_timeout");
        st.execute("RESET application_name");
        st.close();
    }

    private boolean lockAdvisoryLock(Connection conn) throws SQLException {
        if (this.lock == null || this.lock.equals(SProcCall.AdvisoryLock.NoLock.LOCK)) {
            return true;
        }
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("SELECT pg_advisory_lock(" + this.lock.getLockId() + ") AS \"" + this.lock.getName() + "\";");
        boolean b = false;
        if (rs.next()) {
            b = true;
        }
        rs.close();
        st.close();
        return b;
    }

    private boolean unlockAdvisoryLock(Connection conn) throws SQLException {
        if (this.lock == null || this.lock.equals(SProcCall.AdvisoryLock.NoLock.LOCK)) {
            return true;
        }
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("SELECT pg_advisory_unlock(" + this.lock.getLockId() + ")");
        boolean b = false;
        if (rs.next()) {
            b = rs.getBoolean(1);
        }
        rs.close();
        st.close();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeSProc(DataSource ds, String sql, Object[] args, int[] types, InvocationContext invocationContext, Class<?> returnType) {
        SameConnectionDatasource sameConnDs = null;
        try {
            sameConnDs = new SameConnectionDatasource(ds.getConnection());
            this.setTimeout(sameConnDs.getConnection());
            if (!this.lockAdvisoryLock(sameConnDs.getConnection())) {
                throw new RuntimeException("Could not acquire AdvisoryLock " + this.lock.getName());
            }
            Object object = this.executor.executeSProc(sameConnDs, sql, args, types, invocationContext, returnType);
            return object;
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL Exception in execute sproc: " + sql, e);
        }
        finally {
            if (sameConnDs != null) {
                try {
                    if (this.timeoutInMilliSeconds > 0L) {
                        try {
                            this.resetTimeout(sameConnDs.getConnection());
                        }
                        catch (SQLException ex) {
                            LOG.error("Exception in reseting statement timeout!", (Throwable)ex);
                        }
                    }
                    if (this.lock != null && !this.lock.equals(SProcCall.AdvisoryLock.NoLock.LOCK)) {
                        try {
                            this.unlockAdvisoryLock(sameConnDs.getConnection());
                        }
                        catch (SQLException ex) {
                            LOG.error("Exception in reseting advisory lock!", (Throwable)ex);
                        }
                    }
                }
                finally {
                    try {
                        sameConnDs.close();
                    }
                    catch (SQLException ex) {
                        LOG.error("Exception in closing underlying connection!", (Throwable)ex);
                    }
                }
            }
        }
    }
}

