/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy.executors;

import com.google.common.collect.Sets;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.proxy.InvocationContext;
import org.zalando.sprocwrapper.proxy.executors.Executor;

public class ValidationExecutorWrapper
implements Executor {
    private final Executor executor;
    private static final Logger LOG = LoggerFactory.getLogger(ValidationExecutorWrapper.class);
    private static ValidatorFactory factory;

    public ValidationExecutorWrapper(Executor e) {
        this.executor = e;
    }

    public Object executeSProc(DataSource ds, String sql, Object[] args, int[] types, InvocationContext invocationContext, Class returnType) {
        if (factory != null) {
            Validator validator = factory.getValidator();
            HashSet constraintViolations = Sets.newHashSet();
            if (args != null) {
                constraintViolations.addAll(validator.forExecutables().validateParameters(invocationContext.getProxy(), invocationContext.getMethod(), invocationContext.getArgs(), new Class[0]));
            }
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException("SPROC call does not meet all constraints. Aborting.", (Set)constraintViolations);
            }
            Object result = this.executor.executeSProc(ds, sql, args, types, invocationContext, returnType);
            if (result != null) {
                constraintViolations.addAll(validator.validate(result, new Class[0]));
                if (!constraintViolations.isEmpty()) {
                    throw new ConstraintViolationException("SPROC return object does not meet all constraints.", (Set)constraintViolations);
                }
            }
            return result;
        }
        return this.executor.executeSProc(ds, sql, args, types, invocationContext, returnType);
    }

    static {
        try {
            factory = Validation.buildDefaultValidatorFactory();
        }
        catch (Exception e) {
            LOG.error("Could not build default validator factory", (Throwable)e);
        }
    }
}

