/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.postgresql.jdbc.PgArray;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.zalando.typemapper.core.Mapping;
import org.zalando.typemapper.core.db.DbFunction;
import org.zalando.typemapper.core.db.DbFunctionRegister;
import org.zalando.typemapper.core.db.DbTypeField;
import org.zalando.typemapper.core.fieldMapper.ArrayFieldMapper;
import org.zalando.typemapper.core.fieldMapper.ObjectFieldMapper;
import org.zalando.typemapper.core.result.ArrayResultNode;
import org.zalando.typemapper.core.result.DbResultNode;
import org.zalando.typemapper.core.result.DbResultNodeType;
import org.zalando.typemapper.core.result.MapResultNode;
import org.zalando.typemapper.core.result.ObjectResultNode;
import org.zalando.typemapper.core.result.ResultTree;
import org.zalando.typemapper.core.result.SimpleResultNode;
import org.zalando.typemapper.parser.exception.RowParserException;
import org.zalando.typemapper.parser.postgres.ParseUtils;

public class TypeMapper<ITEM>
implements RowMapper<ITEM> {
    private static final Logger LOG = LoggerFactory.getLogger(TypeMapper.class);
    private final Class<ITEM> resultClass;
    private final List<Mapping> mappings;

    TypeMapper(Class<ITEM> resultClass) {
        this.resultClass = resultClass;
        this.mappings = Mapping.getMappingsForClass(this.resultClass);
    }

    public ITEM mapRow(ResultSet set, int count) throws SQLException {
        ITEM result = null;
        try {
            Class<ITEM> resultClass = this.getResultClass();
            if (resultClass.isEnum()) {
                LOG.debug("{} is an Enum", (Object)resultClass.getName());
                String enumValue = set.getString(1);
                if (enumValue != null) {
                    result = Enum.valueOf(resultClass, set.getString(1));
                }
            } else {
                ResultTree resultTree = this.extractResultTree(set);
                result = resultClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.fillObject(result, resultTree);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SQLException(String.valueOf(this.getResultClass()) + " has no public nullary constructor: ", e);
        }
        return result;
    }

    private ResultTree extractResultTree(ResultSet set) throws SQLException {
        PgResultSet pgSet = set.unwrap(PgResultSet.class);
        ResultSetMetaData rsMetaData = pgSet.getMetaData();
        ResultTree tree = new ResultTree();
        for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
            PGobject pgObj;
            long typeId = pgSet.getColumnOID(i);
            DbResultNode node = null;
            Object obj = pgSet.getObject(i);
            String name = rsMetaData.getColumnName(i);
            if (obj instanceof PGobject && ((PGobject)obj).getType().equals("record")) {
                List<String> fieldValues;
                pgObj = (PGobject)obj;
                DbFunction function = DbFunctionRegister.getFunction(name, pgSet.getStatement().getConnection());
                try {
                    fieldValues = ParseUtils.postgresROW2StringList(pgObj.getValue());
                }
                catch (RowParserException e) {
                    throw new SQLException(e);
                }
                int j = 1;
                for (String fieldValue : fieldValues) {
                    DbTypeField fieldDef = function.getFieldByPos(j);
                    DbResultNode currentNode = fieldDef.getType().equals("USER-DEFINED") ? new ObjectResultNode(fieldValue, fieldDef.getName(), fieldDef.getTypeName(), fieldDef.getTypeId(), pgSet.getStatement().getConnection()) : (fieldDef.getType().equals("ARRAY") ? new ArrayResultNode(fieldDef.getName(), fieldValue, fieldDef.getTypeName().substring(1), fieldDef.getTypeId(), pgSet.getStatement().getConnection()) : new SimpleResultNode(fieldValue, fieldDef.getName()));
                    tree.addChild(currentNode);
                    ++j;
                }
                ++i;
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                node = new MapResultNode(map, name);
            } else if (obj instanceof PGobject) {
                pgObj = (PGobject)obj;
                node = new ObjectResultNode(pgObj.getValue(), name, pgObj.getType(), typeId, pgSet.getStatement().getConnection());
            } else if (obj instanceof PgArray) {
                PgArray arrayObj = (PgArray)obj;
                String typeName = arrayObj.getBaseTypeName();
                String value = arrayObj.toString();
                node = new ArrayResultNode(name, value, typeName, typeId, pgSet.getStatement().getConnection());
            } else {
                node = new SimpleResultNode(obj, name);
            }
            tree.addChild(node);
        }
        LOG.debug("Extracted ResultTree: {}", (Object)tree);
        return tree;
    }

    private void fillObject(Object result, ResultTree tree) throws SQLException {
        for (Mapping mapping : this.getMappings()) {
            try {
                Object value;
                DbResultNode node = tree.getChildByName(mapping.getName());
                if (node == null) {
                    if (!mapping.isOptionalField()) continue;
                    mapping.map(result, null);
                    continue;
                }
                if (DbResultNodeType.SIMPLE == node.getNodeType()) {
                    String fieldStringValue = node.getValue();
                    Object value2 = mapping.getFieldMapper().mapField(fieldStringValue, mapping.getFieldClass());
                    mapping.map(result, value2);
                    continue;
                }
                if (DbResultNodeType.MAP == node.getNodeType()) {
                    value = ((MapResultNode)node).getMap();
                    mapping.map(result, value);
                    continue;
                }
                if (DbResultNodeType.OBJECT == node.getNodeType()) {
                    value = ObjectFieldMapper.mapFromDbObjectNode(mapping.getFieldClass(), (ObjectResultNode)node, mapping);
                    mapping.map(result, value);
                    continue;
                }
                if (DbResultNodeType.ARRAY != node.getNodeType()) continue;
                value = ArrayFieldMapper.mapField(mapping.getField(), (ArrayResultNode)node);
                mapping.map(result, value);
            }
            catch (Exception e) {
                LOG.error("Could not map property {} of class {}", new Object[]{mapping.getName(), this.resultClass.getSimpleName(), e});
            }
        }
    }

    public Class<ITEM> getResultClass() {
        return this.resultClass;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }
}

