/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.fieldMapper;

import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.postgresql.jdbc.PostgresJDBCDriverReusedTimestampUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.typemapper.core.fieldMapper.FieldMapper;

public class DateFieldMapper
implements FieldMapper {
    private static final Logger LOG = LoggerFactory.getLogger(DateFieldMapper.class);
    private static PostgresJDBCDriverReusedTimestampUtils postgresJDBCDriverReusedTimestampUtils = new PostgresJDBCDriverReusedTimestampUtils();

    @Override
    public Object mapField(String string, Class<?> clazz) {
        if (string == null) {
            return null;
        }
        Timestamp date = null;
        try {
            date = postgresJDBCDriverReusedTimestampUtils.toTimestamp(null, string.getBytes(StandardCharsets.UTF_8));
        }
        catch (SQLException e) {
            LOG.error("Invalid date/time string: {}", (Object)string, (Object)e);
        }
        if (date == null) {
            LOG.error("Could not parse date: {}", (Object)string);
            return null;
        }
        if (clazz != null && clazz.equals(Date.class)) {
            return new Date(date.getTime());
        }
        return date;
    }
}

