/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.fieldMapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.typemapper.core.fieldMapper.FieldMapper;

public class EnumerationFieldMapper
implements FieldMapper {
    private static final Logger LOG = LoggerFactory.getLogger(EnumerationFieldMapper.class);

    public Object mapField(String string, Class clazz) {
        if (string == null) {
            return null;
        }
        if (clazz.getEnumConstants() == null) {
            LOG.warn("{} is not an enum", (Object)clazz);
            return null;
        }
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        try {
            int enumValue = Integer.parseInt(string);
            for (Enum e : enumConstants) {
                if (e.ordinal() != enumValue) continue;
                return e;
            }
            LOG.warn("Could not find enum in {} with ordinal {}", (Object)clazz, (Object)string);
        }
        catch (NumberFormatException e) {
            for (Enum en : enumConstants) {
                if (!en.name().equals(string)) continue;
                return en;
            }
            LOG.warn("Could not find enum in {} with name {}", (Object)clazz, (Object)string);
        }
        return null;
    }
}

