/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.parser.postgres;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.zalando.typemapper.parser.exception.ArrayParserException;
import org.zalando.typemapper.parser.exception.ParserException;
import org.zalando.typemapper.parser.exception.RowParserException;

public class ParseUtils {
    private static final String[] trueList = new String[]{"t", "true", "1"};
    private static final String[] falseList = new String[]{"f", "false", "0"};

    public static final List<String> postgresArray2StringList(String value) throws ArrayParserException {
        return ParseUtils.postgresArray2StringList(value, 16);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final List<String> postgresArray2StringList(String value, int appendStringSize) throws ArrayParserException {
        if (!value.startsWith("{") || !value.endsWith("}")) {
            throw new ArrayParserException(String.format("postgresArray2StringList() ARRAY must begin with '{' and ends with '}': %s", value));
        }
        if (value.length() == 2) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] c = value.toCharArray();
        StringBuilder element = new StringBuilder(appendStringSize);
        int i = 1;
        while (c[i] != '}') {
            if (c[i] == ',') {
                char nextChar = c[i + 1];
                if (nextChar == ',' || nextChar == '}') {
                    throw new ArrayParserException("Empty array value at position " + i + " should be quoted: " + value);
                }
                ++i;
                continue;
            }
            if (c[i] == '\"') {
                ++i;
                boolean insideQuote = true;
                while (insideQuote) {
                    char nextChar = c[i + 1];
                    if (c[i] == '\"') {
                        if (nextChar == ',' || nextChar == '}') {
                            result.add(element.toString());
                            element = new StringBuilder(appendStringSize);
                            insideQuote = false;
                        } else {
                            if (nextChar != '\"') throw new ArrayParserException("postgresArray2StringList() char after \" is not valid");
                            element.append(c[++i]);
                        }
                    } else if (c[i] == '\\') {
                        if (nextChar != '\\' && nextChar != '\"') throw new ArrayParserException("postgresArray2StringList() char after \\ is not valid");
                        element.append(c[++i]);
                    } else {
                        element.append(c[i]);
                    }
                    ++i;
                }
                continue;
            }
            while (c[i] != ',' && c[i] != '}') {
                element.append(c[i]);
                ++i;
            }
            if ("NULL".equals(element.toString().toUpperCase(Locale.ENGLISH))) {
                result.add(null);
            } else {
                result.add(element.toString());
            }
            element = new StringBuilder(appendStringSize);
        }
        return result;
    }

    public static final List<String> postgresROW2StringList(String value) throws RowParserException {
        return ParseUtils.postgresROW2StringList(value, 16);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final List<String> postgresROW2StringList(String value, int appendStringSize) throws RowParserException {
        if (((String)value).startsWith("(") && !((String)value).endsWith(")") || !((String)value).startsWith("(") && ((String)value).endsWith(")")) {
            throw new RowParserException("postgresROW2StringList() ROW must begin with '(' and ends with ')': " + (String)value);
        }
        if (!((String)value).startsWith("(") && !((String)value).endsWith(")")) {
            value = "(" + (String)value + ")";
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] c = ((String)value).toCharArray();
        StringBuilder element = new StringBuilder(appendStringSize);
        int i = 1;
        while (c[i] != ')') {
            if (c[i] == ',') {
                char nextChar = c[i + 1];
                if (c[i - 1] == '(') {
                    result.add(null);
                }
                if (nextChar == ',' || nextChar == ')') {
                    result.add(null);
                }
                ++i;
                continue;
            }
            if (c[i] == '\"') {
                ++i;
                boolean insideQuote = true;
                while (insideQuote) {
                    char nextChar = c[i + 1];
                    if (c[i] == '\"') {
                        if (nextChar == ',' || nextChar == ')') {
                            result.add(element.toString());
                            element = new StringBuilder(appendStringSize);
                            insideQuote = false;
                        } else {
                            if (nextChar != '\"') throw new RowParserException("postgresROW2StringList() char after \" is not valid");
                            element.append(c[++i]);
                        }
                    } else if (c[i] == '\\') {
                        if (nextChar != '\\' && nextChar != '\"') throw new RowParserException("postgresROW2StringList() char after \\ is not valid");
                        element.append(c[++i]);
                    } else {
                        element.append(c[i]);
                    }
                    ++i;
                }
                continue;
            }
            while (c[i] != ',' && c[i] != ')') {
                element.append(c[i]);
                ++i;
            }
            result.add(element.length() > 0 ? element.toString() : null);
            element = new StringBuilder(appendStringSize);
        }
        return result;
    }

    public static Boolean getBoolean(String s) throws ParserException {
        if (s == null) {
            return null;
        }
        String b = s.trim().toLowerCase(Locale.US).intern();
        for (int i = 0; i < 3; ++i) {
            if (b.equals(trueList[i])) {
                return Boolean.TRUE;
            }
            if (!b.equals(falseList[i])) continue;
            return Boolean.FALSE;
        }
        throw new ParserException("Cannot convert sting [" + s + "] to Boolean");
    }
}

