/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.postgres;

import com.google.common.base.Optional;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.persistence.Column;
import org.postgresql.jdbc.PostgresJDBCDriverReusedTimestampUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.util.NameUtils;
import org.zalando.typemapper.annotations.DatabaseField;
import org.zalando.typemapper.annotations.DatabaseType;
import org.zalando.typemapper.core.DatabaseFieldDescriptor;
import org.zalando.typemapper.core.Mapping;
import org.zalando.typemapper.core.ValueTransformer;
import org.zalando.typemapper.core.db.DbType;
import org.zalando.typemapper.core.db.DbTypeField;
import org.zalando.typemapper.core.db.DbTypeRegister;
import org.zalando.typemapper.core.fieldMapper.AnyTransformer;
import org.zalando.typemapper.core.fieldMapper.DefaultObjectMapper;
import org.zalando.typemapper.core.fieldMapper.GlobalValueTransformerRegistry;
import org.zalando.typemapper.core.fieldMapper.ObjectMapper;
import org.zalando.typemapper.postgres.HStore;
import org.zalando.typemapper.postgres.PgArray;
import org.zalando.typemapper.postgres.PgRow;

public class PgTypeHelper {
    private static final Map<String, Integer> pgGenericTypeNameToSQLTypeMap;
    private static final Map<Field, DatabaseFieldDescriptor> fieldToDataBaseFieldDescriptorMap;
    private static final PostgresJDBCDriverReusedTimestampUtils postgresJDBCDriverReusedTimestampUtils;
    private static final Logger LOG;
    private static final Map<String, String> pgGenericTypeNameAliasMap;
    private static final Map<Class<?>, String> javaGenericClassToPgTypeNameMap;

    public static final int getSQLType(String typeName) {
        String trimmedTypeName = typeName.trim().toLowerCase(Locale.US);
        Integer n = pgGenericTypeNameToSQLTypeMap.get(trimmedTypeName);
        if (n == null) {
            if ((trimmedTypeName = pgGenericTypeNameAliasMap.get(trimmedTypeName)) != null) {
                return pgGenericTypeNameToSQLTypeMap.get(trimmedTypeName);
            }
            return 1111;
        }
        return n;
    }

    public static String getSQLNameForClass(Class<?> elementClass) {
        if (elementClass == null) {
            return null;
        }
        String typeName = javaGenericClassToPgTypeNameMap.get(elementClass);
        return typeName;
    }

    public static PgTypeDataHolder getObjectAttributesForPgSerialization(Object obj, String typeHint) {
        return PgTypeHelper.getObjectAttributesForPgSerialization(obj, typeHint, null);
    }

    public static PgTypeDataHolder getObjectAttributesForPgSerialization(Object obj, String typeHint, Connection connection) {
        return PgTypeHelper.getObjectAttributesForPgSerialization(obj, typeHint, connection, false);
    }

    private static boolean isCglibProxy(Object obj) {
        try {
            return obj.getClass().getDeclaredField("CGLIB$CALLBACK_0") != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private static Class<?> getActualClass(Object obj) {
        if (PgTypeHelper.isCglibProxy(obj)) {
            return obj.getClass().getSuperclass();
        }
        return obj.getClass();
    }

    public static PgTypeDataHolder getObjectAttributesForPgSerialization(Object obj, String typeHint, Connection connection, boolean forceTypeHint) {
        if (obj == null) {
            throw new NullPointerException();
        }
        String typeName = null;
        Class<?> clazz = PgTypeHelper.getActualClass(obj);
        if (clazz.isPrimitive() || clazz.isArray()) {
            throw new IllegalArgumentException("Passed object should be a class with parameters");
        }
        if (clazz.equals(PgTypeDataHolder.class)) {
            return (PgTypeDataHolder)obj;
        }
        DatabaseType databaseType = clazz.getAnnotation(DatabaseType.class);
        if (databaseType != null) {
            typeName = databaseType.name();
        }
        if (typeName == null || typeName.isEmpty() || forceTypeHint) {
            typeName = typeHint;
        }
        if (typeName == null || typeName.isEmpty()) {
            typeName = NameUtils.camelCaseToUnderscore(clazz.getSimpleName());
        }
        ArrayList<Object> resultList = null;
        TreeMap<Integer, Object> resultPositionMap = null;
        Field[] fields = PgTypeHelper.getFields(clazz);
        HashMap<String, DbTypeField> dbFields = null;
        if (connection != null) {
            try {
                DbType dbType = DbTypeRegister.getDbType(typeName, connection);
                dbFields = new HashMap<String, DbTypeField>();
                for (DbTypeField dbfield : dbType.getFields()) {
                    dbFields.put(dbfield.getName(), dbfield);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not get PG type information for " + typeName, e);
            }
        } else {
            Arrays.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field a, Field b) {
                    return a.getName().compareTo(b.getName());
                }
            });
        }
        for (Field f : fields) {
            int fieldPosition;
            Object value;
            DatabaseFieldDescriptor databaseFieldDescriptor = PgTypeHelper.getDatabaseFieldDescriptor(f);
            if (databaseFieldDescriptor == null) continue;
            if (!f.canAccess(obj)) {
                f.setAccessible(true);
            }
            try {
                value = PgTypeHelper.getOptionalValue(f.get(obj));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not read value of field " + f.getName(), e);
            }
            if (value != null) {
                value = PgTypeHelper.applyTransformer(f, databaseFieldDescriptor, value);
            }
            if ((fieldPosition = databaseFieldDescriptor.getPosition()) > 0) {
                if (resultPositionMap == null) {
                    resultPositionMap = new TreeMap<Integer, Object>();
                }
                resultPositionMap.put(fieldPosition, value);
                continue;
            }
            DbTypeField dbField = null;
            if (dbFields != null) {
                String dbFieldName;
                if (resultPositionMap == null) {
                    resultPositionMap = new TreeMap();
                }
                if ((dbField = (DbTypeField)dbFields.get(dbFieldName = Mapping.getDatabaseFieldName(f, databaseFieldDescriptor.getName()))) == null) {
                    if (databaseType == null || !databaseType.partial()) {
                        throw new IllegalArgumentException("Field " + f.getName() + " (" + dbFieldName + ") of class " + clazz.getSimpleName() + " could not be found in database type " + typeName);
                    }
                } else {
                    resultPositionMap.put(dbField.getPosition(), value);
                }
            }
            if (dbField != null) continue;
            if (resultList == null) {
                resultList = new ArrayList<Object>();
            }
            if (databaseType != null && databaseType.partial()) continue;
            resultList.add(value);
        }
        int fieldsWithDefinedPositions = resultPositionMap == null ? 0 : resultPositionMap.size();
        int fieldsWithUndefinedPositions = resultList == null ? 0 : resultList.size();
        int fieldsInDb = dbFields == null ? 0 : dbFields.size();
        if (fieldsInDb != fieldsWithDefinedPositions & connection != null) {
            LOG.error("fieldsInDb({})!=fieldsWithDefinedPositions({}) @DatabaseField annotation missing", (Object)fieldsInDb, (Object)fieldsWithDefinedPositions);
            throw new IllegalArgumentException("Class " + clazz.getName() + " should have all its database related fields annotated");
        }
        if (fieldsWithDefinedPositions > 0 && fieldsWithUndefinedPositions > 0) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " should have all its database related fields marked with correct names or positions");
        }
        if (fieldsWithDefinedPositions > 0) {
            return new PgTypeDataHolder(typeName, Collections.unmodifiableCollection(resultPositionMap.values()));
        }
        return new PgTypeDataHolder(typeName, Collections.unmodifiableCollection(resultList));
    }

    private static Object getOptionalValue(Object o) {
        if (o instanceof Optional) {
            Optional optional = (Optional)o;
            return optional.isPresent() ? optional.get() : null;
        }
        return o;
    }

    private static Field[] getFields(Class<?> clazz) {
        DatabaseType databaseType = clazz.getAnnotation(DatabaseType.class);
        if (databaseType == null || !databaseType.inheritance()) {
            return clazz.getDeclaredFields();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> targetClass = clazz;
        do {
            fields.addAll(Arrays.asList(targetClass.getDeclaredFields()));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return fields.toArray(new Field[fields.size()]);
    }

    public static DatabaseFieldDescriptor getDatabaseFieldDescriptor(Field field) {
        DatabaseFieldDescriptor databaseFieldDescriptor = fieldToDataBaseFieldDescriptorMap.get(field);
        if (databaseFieldDescriptor == null) {
            DatabaseField databaseField = field.getAnnotation(DatabaseField.class);
            if (databaseField != null) {
                databaseFieldDescriptor = new DatabaseFieldDescriptor(databaseField);
            } else {
                Column column = field.getAnnotation(Column.class);
                if (column != null) {
                    databaseFieldDescriptor = new DatabaseFieldDescriptor(column);
                }
            }
            fieldToDataBaseFieldDescriptorMap.put(field, databaseFieldDescriptor);
        }
        return databaseFieldDescriptor;
    }

    private static Object applyTransformer(Field f, DatabaseFieldDescriptor databaseFieldDescriptor, Object value) {
        Class<ObjectMapper<?>> mapperClass;
        if (databaseFieldDescriptor.getTransformer() != null && !AnyTransformer.class.isAssignableFrom(databaseFieldDescriptor.getTransformer())) {
            try {
                ValueTransformer<?, ?> transformer = databaseFieldDescriptor.getTransformer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                value = transformer.marshalToDb(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not instantiate transformer of field " + f.getName(), e);
            }
        }
        if ((mapperClass = databaseFieldDescriptor.getMapper()) != null && mapperClass != DefaultObjectMapper.class) {
            try {
                ObjectMapper<?> mapper = mapperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                value = mapper.marshalToDb(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not instantiate mapper of field " + f.getName(), e);
            }
        }
        return value;
    }

    public static String toPgString(Object o) {
        return PgTypeHelper.toPgString(o, null);
    }

    public static String toPgString(Object o, Connection connection) {
        if (o == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = o.getClass();
        ValueTransformer<?, ?> valueTransformer = GlobalValueTransformerRegistry.getValueTransformerForClass(clazz);
        if (valueTransformer != null && ((o = valueTransformer.marshalToDb(o)) == null || o.getClass() != clazz)) {
            return PgTypeHelper.toPgString(o, connection);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            sb.append((Boolean)o != false ? (char)'t' : 'f');
        } else if (clazz.isPrimitive() || o instanceof Number) {
            sb.append(o);
        } else if (o instanceof PGobject || o instanceof java.sql.Array || o instanceof CharSequence || o instanceof Character || clazz == Character.TYPE) {
            sb.append(o.toString());
        } else if (clazz.isArray()) {
            Class<?> componentClazz = clazz.getComponentType();
            if (componentClazz.isPrimitive()) {
                int l = Array.getLength(o);
                ArrayList<String> stringList = new ArrayList<String>(l);
                for (int i = 0; i < l; ++i) {
                    stringList.add(String.valueOf(Array.get(o, i)));
                }
                sb.append(PgArray.ARRAY(stringList).toString());
            } else {
                sb.append(PgArray.ARRAY((Object[])o).toString());
            }
        } else if (clazz.isEnum()) {
            sb.append(((Enum)o).name());
        } else if (o instanceof java.util.Date) {
            Timestamp tmpd = null;
            tmpd = o instanceof Timestamp ? (Timestamp)o : new Timestamp(((java.util.Date)o).getTime());
            sb.append(postgresJDBCDriverReusedTimestampUtils.toString(null, tmpd));
        } else if (o instanceof Map) {
            Map map = (Map)o;
            sb.append(HStore.serialize(map));
        } else if (o instanceof Collection) {
            sb.append(PgArray.ARRAY((Collection)o).toString(connection));
        } else {
            try {
                sb.append(PgTypeHelper.asPGobject(o, null, connection).toString());
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Could not serialize object of class " + clazz.getName(), e);
            }
        }
        return sb.toString();
    }

    public static PgRow asPGobject(Object o) throws SQLException {
        return PgTypeHelper.asPGobject(o, null, null);
    }

    public static PgRow asPGobject(Object o, String typeHint) throws SQLException {
        return PgTypeHelper.asPGobject(o, typeHint, null);
    }

    public static PgRow asPGobject(Object o, String typeHint, Connection connection) throws SQLException {
        return new PgRow(PgTypeHelper.getObjectAttributesForPgSerialization(o, typeHint, connection), connection);
    }

    public static PgRow asPGobject(Object o, String typeHint, Connection connection, boolean forceTypeHint) throws SQLException {
        return new PgRow(PgTypeHelper.getObjectAttributesForPgSerialization(o, typeHint, connection, forceTypeHint), connection);
    }

    static {
        fieldToDataBaseFieldDescriptorMap = Collections.synchronizedMap(new HashMap());
        postgresJDBCDriverReusedTimestampUtils = new PostgresJDBCDriverReusedTimestampUtils();
        LOG = LoggerFactory.getLogger(PgTypeHelper.class);
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put("int2", 5);
        m.put("int4", 4);
        m.put("oid", -5);
        m.put("int8", -5);
        m.put("money", 8);
        m.put("numeric", 2);
        m.put("float4", 7);
        m.put("float8", 8);
        m.put("bpchar", 1);
        m.put("varchar", 12);
        m.put("text", 12);
        m.put("name", 12);
        m.put("bool", 16);
        m.put("bit", -7);
        m.put("date", 91);
        m.put("time", 92);
        m.put("timetz", 92);
        m.put("timestamp", 93);
        m.put("timestamptz", 93);
        pgGenericTypeNameToSQLTypeMap = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("smallint", "int2");
        m.put("integer", "int4");
        m.put("int", "int4");
        m.put("bigint", "int8");
        m.put("real", "float4");
        m.put("float", "float8");
        m.put("double precision", "float8");
        m.put("boolean", "bool");
        m.put("decimal", "numeric");
        m.put("character varying", "varchar");
        m.put("char", "bpchar");
        m.put("character", "bpchar");
        pgGenericTypeNameAliasMap = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(Short.TYPE, "int2");
        m.put(Short.class, "int2");
        m.put(Integer.TYPE, "int4");
        m.put(Integer.class, "int4");
        m.put(Long.TYPE, "int8");
        m.put(Long.class, "int8");
        m.put(Float.TYPE, "float4");
        m.put(Float.class, "float4");
        m.put(Double.TYPE, "float8");
        m.put(Double.class, "float8");
        m.put(Character.TYPE, "bpchar");
        m.put(Character.class, "bpchar");
        m.put(String.class, "text");
        m.put(Boolean.TYPE, "bool");
        m.put(Boolean.class, "bool");
        m.put(java.util.Date.class, "timestamp");
        m.put(Date.class, "timestamp");
        m.put(Timestamp.class, "timestamp");
        m.put(Time.class, "timestamp");
        m.put(UUID.class, "uuid");
        javaGenericClassToPgTypeNameMap = Collections.unmodifiableMap(m);
    }

    public static final class PgTypeDataHolder {
        private final String typeName;
        private final Collection<Object> attributes;

        public PgTypeDataHolder(String typeName, Collection<Object> attributes) {
            this.typeName = typeName;
            this.attributes = attributes;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Collection<Object> getAttributes() {
            return this.attributes;
        }
    }
}

