/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.core;

import com.fasterxml.jackson.core.JsonPointer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.zally.core.ApiValidator;
import org.zalando.zally.core.CheckDetails;
import org.zalando.zally.core.ContentParseResult;
import org.zalando.zally.core.JsonPointerLocator;
import org.zalando.zally.core.ObjectTreeReader;
import org.zalando.zally.core.Result;
import org.zalando.zally.core.RulesManager;
import org.zalando.zally.core.RulesPolicy;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&\u00a2\u0006\u0002\u0010\u0015J+\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J \u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u0014H&J(\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180%2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\b\u0010#\u001a\u0004\u0018\u00010\u0014H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lorg/zalando/zally/core/RulesValidator;", "RootT", "", "Lorg/zalando/zally/core/ApiValidator;", "rules", "Lorg/zalando/zally/core/RulesManager;", "(Lorg/zalando/zally/core/RulesManager;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "reader", "Lorg/zalando/zally/core/ObjectTreeReader;", "getRules", "()Lorg/zalando/zally/core/RulesManager;", "ignore", "", "root", "pointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "ruleId", "", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonPointer;Ljava/lang/String;)Z", "invoke", "", "Lorg/zalando/zally/core/Result;", "details", "Lorg/zalando/zally/core/CheckDetails;", "locator", "Lorg/zalando/zally/core/JsonPointerLocator;", "(Lorg/zalando/zally/core/CheckDetails;Ljava/lang/Object;Lorg/zalando/zally/core/JsonPointerLocator;)Ljava/lang/Iterable;", "isCheckMethod", "isRootParameterNeeded", "parse", "Lorg/zalando/zally/core/ContentParseResult;", "content", "authorization", "validate", "", "policy", "Lorg/zalando/zally/core/RulesPolicy;", "zally-core"})
public abstract class RulesValidator<RootT>
implements ApiValidator {
    private final Logger log;
    private final ObjectTreeReader reader;
    @NotNull
    private final RulesManager rules;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Result> validate(@NotNull String content, @NotNull RulesPolicy policy, @Nullable String authorization) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)policy, (String)"policy");
        ContentParseResult<RootT> parseResult = this.parse(content, authorization);
        JsonPointerLocator locator = new JsonPointerLocator(content);
        ContentParseResult<RootT> contentParseResult = parseResult;
        if (contentParseResult instanceof ContentParseResult.NotApplicable) {
            list = CollectionsKt.emptyList();
        } else if (contentParseResult instanceof ContentParseResult.ParsedWithErrors) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((ContentParseResult.ParsedWithErrors)parseResult).getViolations();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void violation;
                Violation violation2 = (Violation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                URI uRI = URI.create("https://github.com/zalando/zally/blob/master/server/rules.md");
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(\"https://gith\u2026/master/server/rules.md\")");
                Result result = new Result("InternalRuleSet", uRI, "Unable to parse API specification", violation.getDescription(), Severity.MUST, violation.getPointer(), locator.locate(violation.getPointer()));
                collection.add(result);
            }
            list = (List)destination$iv$iv;
        } else if (contentParseResult instanceof ContentParseResult.ParsedSuccessfully) {
            void $this$flatMapTo$iv$iv;
            CheckDetails details2;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.rules.checks(policy);
            boolean $i$f$filter = false;
            Iterable $this$mapTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                details2 = (CheckDetails)element$iv$iv;
                boolean bl = false;
                if (!this.isCheckMethod(details2, ((ContentParseResult.ParsedSuccessfully)parseResult).getResult())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                details2 = (CheckDetails)element$iv$iv;
                boolean bl = false;
                Iterable<Result> list$iv$iv = this.invoke(details2, ((ContentParseResult.ParsedSuccessfully)parseResult).getResult(), locator);
                CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            Iterable iterable = $this$sortedBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    T receiver = a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Result)receiver).getViolationType();
                    receiver = b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Severity severity = ((Result)receiver).getViolationType();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)severity));
                }
            };
            list = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public abstract ContentParseResult<RootT> parse(@NotNull String var1, @Nullable String var2);

    private final boolean isCheckMethod(CheckDetails details2, Object root) {
        boolean bl;
        switch (details2.getMethod().getParameters().length) {
            case 1: {
                bl = this.isRootParameterNeeded(details2, root);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRootParameterNeeded(CheckDetails details2, Object root) {
        Parameter[] parameterArray = details2.getMethod().getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameterArray, (String)"details.method.parameters");
        Parameter[] parameterArray2 = parameterArray;
        boolean bl = false;
        Parameter[] parameterArray3 = parameterArray2;
        boolean bl2 = false;
        if (parameterArray3.length == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        Parameter parameter = details2.getMethod().getParameters()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"details.method.parameters[0]");
        if (!parameter.getType().isAssignableFrom(root.getClass())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<Result> invoke(CheckDetails details2, RootT root, JsonPointerLocator locator) {
        void $this$mapTo$iv$iv;
        Violation it;
        Iterable $this$filterNotTo$iv$iv;
        List list;
        Object result;
        Object object;
        this.log.debug("validating " + details2.getMethod().getName() + " of " + details2.getInstance().getClass().getSimpleName() + " rule");
        try {
            object = details2.getMethod().invoke(details2.getInstance(), root);
        }
        catch (InvocationTargetException e) {
            throw (Throwable)new RuntimeException("check invocation failed: id=" + details2.getRule().id() + ' ' + "title=" + details2.getRule().title() + " checkName=" + details2.getMethod().getName() + " reason=" + e.getTargetException(), e);
        }
        Object e = result = object;
        if (e == null) {
            list = CollectionsKt.emptyList();
        } else if (e instanceof Violation) {
            list = CollectionsKt.listOf((Object)result);
        } else if (e instanceof Iterable) {
            list = CollectionsKt.filterIsInstance((Iterable)((Iterable)result), Violation.class);
        } else {
            throw (Throwable)new Exception("Unsupported return type for a @Check method!: " + result.getClass());
        }
        List violations = list;
        e = violations;
        Object object2 = new StringBuilder();
        Object object3 = this.log;
        boolean bl = false;
        int n = e.size();
        object3.debug(((StringBuilder)object2).append(n).append(" violations identified").toString());
        Iterable $this$filterNot$iv = violations;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Violation)element$iv$iv;
            boolean bl2 = false;
            if (this.ignore(root, it.getPointer(), details2.getRule().id())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Violation)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl3 = false;
            object2 = new Result(details2.getRule().id(), details2.getRuleSet().url(details2.getRule()), details2.getRule().title(), it.getDescription(), details2.getCheck().severity(), it.getPointer(), locator.locate(it.getPointer()));
            object3.add(object2);
        }
        return (List)destination$iv$iv;
    }

    public abstract boolean ignore(@NotNull RootT var1, @NotNull JsonPointer var2, @NotNull String var3);

    @NotNull
    public final RulesManager getRules() {
        return this.rules;
    }

    public RulesValidator(@NotNull RulesManager rules) {
        Intrinsics.checkParameterIsNotNull((Object)rules, (String)"rules");
        this.rules = rules;
        this.log = LoggerFactory.getLogger(RulesValidator.class);
        this.reader = new ObjectTreeReader();
    }
}

