/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.HeaderElement;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="166", severity=Severity.MUST, title="Avoid Link in Header Rule")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/zalando/zally/ruleset/zalando/AvoidLinkHeadersRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "description", "", "headersWhitelist", "", "kotlin.jvm.PlatformType", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class AvoidLinkHeadersRule {
    private final Set<String> headersWhitelist;
    private final String description = "Do Not Use Link Headers with JSON entities";

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        HeaderElement it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Set allHeaders = OpenApiUtilKt.getAllHeaders((OpenAPI)context.getApi());
        Iterable $this$filter$iv = allHeaders;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HeaderElement)element$iv$iv;
            boolean bl = false;
            if (!(!this.headersWhitelist.contains(it.getName()) && Intrinsics.areEqual((Object)it.getName(), (Object)"Link"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (HeaderElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Violation violation = context.violation(this.description, it.getElement());
            collection.add(violation);
        }
        return (List)destination$iv$iv;
    }

    public AvoidLinkHeadersRule(@NotNull Config rulesConfig) {
        Intrinsics.checkParameterIsNotNull((Object)rulesConfig, (String)"rulesConfig");
        List list = rulesConfig.getStringList("HttpHeadersRule.whitelist");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"rulesConfig.getStringLis\u2026tpHeadersRule.whitelist\")");
        this.headersWhitelist = CollectionsKt.toSet((Iterable)list);
        this.description = "Do Not Use Link Headers with JSON entities";
    }
}

