/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="235", severity=Severity.SHOULD, title="Name date/time properties using the \"_at\" suffix")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rH\u0002J%\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/zalando/zally/ruleset/zalando/DateTimePropertiesSuffixRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "patterns", "", "Lkotlin/text/Regex;", "propertyFormats", "", "checkProperty", "name", "schema", "Lio/swagger/v3/oas/models/media/Schema;", "generateMessage", "type", "format", "generateMessage$zally_ruleset_zalando", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class DateTimePropertiesSuffixRule {
    private final Set<Regex> patterns;
    private final Set<String> propertyFormats;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Map $this$map$iv = OpenApiUtilKt.getAllProperties((OpenAPI)context.getApi());
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Violation violation;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Schema schema = (Schema)it.getValue();
            String result = this.checkProperty((String)it.getKey(), (Schema<Object>)schema);
            if (result != null) {
                String string;
                boolean bl3 = false;
                boolean bl4 = false;
                String it2 = string;
                boolean bl5 = false;
                violation = context.violation(result, (Object)schema);
            } else {
                violation = null;
            }
            Violation violation2 = violation;
            collection.add(violation2);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    private final String checkProperty(String name, Schema<Object> schema) {
        if (Intrinsics.areEqual((Object)schema.getType(), (Object)"string") && this.propertyFormats.contains(schema.getFormat())) {
            Object v0;
            block3: {
                Iterable iterable = this.patterns;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Regex it = (Regex)t;
                    boolean bl3 = false;
                    if (!it.matches((CharSequence)name)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((Regex)v0 == null) {
                String string = schema.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.type");
                String string2 = schema.getFormat();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"schema.format");
                return this.generateMessage$zally_ruleset_zalando(name, string, string2);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateMessage$zally_ruleset_zalando(@NotNull String name, @NotNull String type, @NotNull String format) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Iterable iterable = this.patterns;
        StringBuilder stringBuilder = new StringBuilder().append("Property \"").append(name).append("\" of type \"").append(type).append("\" and format \"").append(format).append("\" should match one of the patterns ");
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Regex regex = (Regex)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(collection).append('\"').toString();
    }

    /*
     * WARNING - void declaration
     */
    public DateTimePropertiesSuffixRule(@NotNull Config rulesConfig) {
        Collection<Regex> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)rulesConfig, (String)"rulesConfig");
        List list = rulesConfig.getStringList(DateTimePropertiesSuffixRule.class.getSimpleName() + ".patterns");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"rulesConfig\n        .get\u2026va.simpleName}.patterns\")");
        Iterable iterable = list;
        DateTimePropertiesSuffixRule dateTimePropertiesSuffixRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Regex regex = new Regex((String)v1);
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        dateTimePropertiesSuffixRule.patterns = CollectionsKt.toSet((Iterable)collection);
        this.propertyFormats = SetsKt.setOf((Object[])new String[]{"date", "date-time"});
    }
}

