/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="183", severity=Severity.MUST, title="Use Only the Specified Proprietary Zalando Headers")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00130\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u0006 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u0006 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u0006 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/zalando/zally/ruleset/zalando/ProprietaryHeadersRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "requestDescription", "", "requestHeaders", "", "responseDescription", "responseHeaders", "standardRequestHeaders", "", "kotlin.jvm.PlatformType", "standardResponseHeaders", "zalandoHeaders", "Lio/swagger/v3/oas/models/parameters/Parameter;", "context", "Lorg/zalando/zally/rule/api/Context;", "", "Lio/swagger/v3/oas/models/headers/Header;", "validateRequestHeaders", "Lorg/zalando/zally/rule/api/Violation;", "validateResponseHeaders", "zally-ruleset-zalando"})
public final class ProprietaryHeadersRule {
    private final List<String> zalandoHeaders;
    private final List<String> standardRequestHeaders;
    private final List<String> standardResponseHeaders;
    private final List<String> requestHeaders;
    private final List<String> responseHeaders;
    private final String requestDescription = "use only standardized or specified request headers";
    private final String responseDescription = "use only standardized or specified response headers";

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validateRequestHeaders(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Parameter it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable $this$filterNot$iv = this.requestHeaders(context);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String string;
            String string2;
            it = (Parameter)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getName(), (String)"it.name");
            List<String> list = this.requestHeaders;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            if (list.contains(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Parameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Violation violation = context.violation(this.requestDescription, (Object)it);
            collection.add(violation);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validateResponseHeaders(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable $this$filterNot$iv = this.responseHeaders(context);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String string;
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String string2 = (String)it.getKey();
            List<String> list = this.responseHeaders;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            if (list.contains(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Violation violation = context.violation(this.responseDescription, it.getValue());
            collection.add(violation);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Parameter> requestHeaders(Context context) {
        void $this$flatMapTo$iv$iv;
        Paths paths = context.getApi().getPaths();
        Collection collection = paths != null ? paths.values() : null;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = collection2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            PathItem it = (PathItem)element$iv$iv;
            boolean bl2 = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.readOperations() : null;
            boolean bl3 = false;
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv2 = list2;
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$filterTo$iv$iv;
                Operation it2 = (Operation)element$iv$iv2;
                boolean bl4 = false;
                Operation operation = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"it");
                List list3 = operation.getParameters();
                boolean bl5 = false;
                List list4 = list3;
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                Iterable $this$filter$iv = list4;
                boolean $i$f$filter = false;
                Iterable iterable3 = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                    Parameter it3 = (Parameter)element$iv$iv3;
                    boolean bl6 = false;
                    Parameter parameter = it3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"it");
                    if (!Intrinsics.areEqual((Object)"header", (Object)parameter.getIn())) continue;
                    destination$iv$iv3.add(element$iv$iv3);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map.Entry<String, Header>> responseHeaders(Context context) {
        void $this$flatMapTo$iv$iv;
        Paths paths = context.getApi().getPaths();
        Collection collection = paths != null ? paths.values() : null;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = collection2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            PathItem it = (PathItem)element$iv$iv;
            boolean bl2 = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.readOperations() : null;
            boolean bl3 = false;
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv2 = list2;
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$flatMapTo$iv$iv3;
                Operation it2 = (Operation)element$iv$iv2;
                boolean bl4 = false;
                Operation operation = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"it");
                Map map = (Map)operation.getResponses();
                boolean bl5 = false;
                Map map2 = map;
                if (map2 == null) {
                    map2 = MapsKt.emptyMap();
                }
                Iterable $this$flatMap$iv3 = map2.values();
                boolean $i$f$flatMap3 = false;
                Iterable iterable3 = $this$flatMap$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo3 = false;
                for (Object element$iv$iv3 : $this$flatMapTo$iv$iv3) {
                    ApiResponse it3 = (ApiResponse)element$iv$iv3;
                    boolean bl6 = false;
                    ApiResponse apiResponse = it3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)apiResponse, (String)"it");
                    Map map3 = apiResponse.getHeaders();
                    boolean bl7 = false;
                    Map map4 = map3;
                    if (map4 == null) {
                        map4 = MapsKt.emptyMap();
                    }
                    Iterable list$iv$iv = map4.entrySet();
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public ProprietaryHeadersRule(@NotNull Config rulesConfig) {
        String string;
        String string2;
        boolean bl;
        String it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)rulesConfig, (String)"rulesConfig");
        this.zalandoHeaders = rulesConfig.getConfig(this.getClass().getSimpleName()).getStringList("zalando_headers");
        this.standardRequestHeaders = rulesConfig.getConfig(this.getClass().getSimpleName()).getStringList("standard_request_headers");
        this.standardResponseHeaders = rulesConfig.getConfig(this.getClass().getSimpleName()).getStringList("standard_response_headers");
        List<String> list = this.standardRequestHeaders;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"standardRequestHeaders");
        Collection collection2 = list;
        List<String> list2 = this.zalandoHeaders;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"zalandoHeaders");
        Iterable iterable = CollectionsKt.plus((Collection)collection2, (Iterable)list2);
        ProprietaryHeadersRule proprietaryHeadersRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            bl = false;
            void v3 = string2;
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        proprietaryHeadersRule.requestHeaders = collection;
        List<String> list3 = this.standardResponseHeaders;
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"standardResponseHeaders");
        Collection collection3 = list3;
        List<String> list4 = this.zalandoHeaders;
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"zalandoHeaders");
        $this$map$iv = CollectionsKt.plus((Collection)collection3, (Iterable)list4);
        proprietaryHeadersRule = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            bl = false;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        proprietaryHeadersRule.responseHeaders = collection;
        this.requestDescription = "use only standardized or specified request headers";
        this.responseDescription = "use only standardized or specified response headers";
    }
}

