/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="104", severity=Severity.MUST, title="Secure Endpoints with OAuth 2.0")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Lorg/zalando/zally/ruleset/zalando/SecureWithOAuth2Rule;", "", "()V", "checkSecuritySchemesOAuth2IsUsed", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkSecuritySchemesOnlyOAuth2IsUsed", "", "checkUsedScopesAreSpecified", "zally-ruleset-zalando"})
public final class SecureWithOAuth2Rule {
    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkSecuritySchemesOAuth2IsUsed(@NotNull Context context) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getApi().getComponents();
            Collection collection = object != null && (object = object.getSecuritySchemes()) != null ? object.values() : null;
            boolean bl2 = false;
            Collection collection2 = collection;
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = collection2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SecurityScheme it = (SecurityScheme)element$iv;
                    boolean bl3 = false;
                    SecurityScheme securityScheme = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)securityScheme, (String)"it");
                    if (!(SecurityScheme.Type.OAUTH2 == securityScheme.getType())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean oauth2IsUsed = bl;
        return !oauth2IsUsed ? context.violation("API has to be secured by OAuth2", JsonPointerExtensionsKt.toJsonPointer((String)"/components/securitySchemes")) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkSecuritySchemesOnlyOAuth2IsUsed(@NotNull Context context) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getApi().getComponents();
        if (object != null && (object = object.getSecuritySchemes()) != null && (object = object.values()) != null) {
            void $this$mapTo$iv$iv;
            SecurityScheme it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SecurityScheme)element$iv$iv;
                boolean bl = false;
                SecurityScheme securityScheme = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)securityScheme, (String)"it");
                if (!(securityScheme.getType() != SecurityScheme.Type.OAUTH2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SecurityScheme)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SecurityScheme securityScheme = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)securityScheme, (String)"it");
                Violation violation = context.violation("Only OAuth2 is allowed to secure the API", (Object)securityScheme);
                collection.add(violation);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = list;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkUsedScopesAreSpecified(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$flatMapTo$iv$iv2;
        Object object;
        boolean bl;
        Collection collection;
        Object scheme;
        void $this$flatMapTo$iv$iv32;
        boolean bl2;
        Object object2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!context.isOpenAPI3()) {
            return CollectionsKt.emptyList();
        }
        Object object3 = context.getApi().getComponents();
        Set set = object3 != null && (object3 = object3.getSecuritySchemes()) != null ? object3.entrySet() : null;
        boolean bl3 = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SecurityScheme scheme2;
            Map.Entry $$_$_scheme = (Map.Entry)element$iv$iv;
            boolean bl4 = false;
            object2 = $$_$_scheme;
            bl2 = false;
            SecurityScheme securityScheme = scheme2 = (SecurityScheme)object2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)securityScheme, (String)"scheme");
            if (!(SecurityScheme.Type.OAUTH2 == securityScheme.getType())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap22 = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv32) {
            void $this$mapTo$iv$iv2;
            Map.Entry $group_scheme = (Map.Entry)element$iv$iv;
            boolean bl5 = false;
            object2 = $group_scheme;
            bl2 = false;
            String group = (String)object2.getKey();
            object2 = $group_scheme;
            bl2 = false;
            SecurityScheme securityScheme = scheme = (SecurityScheme)object2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)securityScheme, (String)"scheme");
            OAuthFlows oAuthFlows = securityScheme.getFlows();
            object2 = (Map)(oAuthFlows != null && (oAuthFlows = oAuthFlows.getClientCredentials()) != null ? oAuthFlows.getScopes() : null);
            bl2 = false;
            Object object4 = object2;
            if (object4 == null) {
                object4 = MapsKt.emptyMap();
            }
            Iterable $this$map$iv = object4.keySet();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void scope;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv3;
                bl = false;
                object = TuplesKt.to((Object)group, (Object)scope);
                collection.add(object);
            }
            Iterable list$iv$iv2 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        Set specifiedScopes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Paths paths = context.getApi().getPaths();
        Collection $i$f$flatMap22 = paths != null ? paths.values() : null;
        boolean $this$flatMapTo$iv$iv32 = false;
        Collection collection2 = $i$f$flatMap22;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv2 = collection2;
        boolean $i$f$flatMap = false;
        destination$iv$iv2 = $this$flatMap$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            PathItem it = (PathItem)element$iv$iv;
            boolean bl6 = false;
            PathItem pathItem = it;
            List $i$f$map = pathItem != null ? pathItem.readOperations() : null;
            boolean group = false;
            List list = $i$f$map;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv3 = list;
            boolean $i$f$flatMap3 = false;
            scheme = $this$flatMap$iv3;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo3 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                Operation it2 = (Operation)element$iv$iv2;
                boolean bl7 = false;
                Operation operation = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"it");
                collection = operation.getSecurity();
                bl = false;
                Collection collection3 = collection;
                if (collection3 == null) {
                    collection3 = CollectionsKt.emptyList();
                }
                list$iv$iv = collection3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv3 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv3);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv4;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv4 = new ArrayList();
        $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            SecurityRequirement secReq = (SecurityRequirement)element$iv$iv;
            boolean bl8 = false;
            Set set3 = secReq.keySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"secReq.keys");
            Iterable $this$flatMap$iv4 = set3;
            boolean $i$f$flatMap4 = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv4;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo4 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv3;
                String group = (String)element$iv$iv2;
                boolean bl9 = false;
                collection = (List)secReq.get((Object)group);
                bl = false;
                Collection collection4 = collection;
                if (collection4 == null) {
                    collection4 = CollectionsKt.emptyList();
                }
                Iterable $this$map$iv = collection4;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void scope;
                    String string = (String)item$iv$iv;
                    Collection collection5 = destination$iv$iv5;
                    boolean bl10 = false;
                    Pair pair = TuplesKt.to((Object)group, (Object)scope);
                    collection5.add(pair);
                }
                list$iv$iv = (List)destination$iv$iv5;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv4 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv4);
        }
        List usedScopes = (List)destination$iv$iv4;
        Iterable $this$filterNot$iv = usedScopes;
        boolean $i$f$filterNot = false;
        $this$flatMapTo$iv$iv2 = $this$filterNot$iv;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl11 = false;
            if (specifiedScopes.contains(it)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv4;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $group_scope;
            Pair it = (Pair)item$iv$iv;
            Collection collection6 = destination$iv$iv4;
            boolean bl12 = false;
            String group = (String)$group_scope.component1();
            String scope = (String)$group_scope.component2();
            String string = "The scope '" + group + '/' + scope + "' is not specified in the clientCredentials flow of the " + "OAuth2 security definition";
            String string2 = scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"scope");
            Violation violation = context.violation(string, (Object)string2);
            collection6.add(violation);
        }
        return (List)destination$iv$iv4;
    }
}

