/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.fasterxml.jackson.core.JsonPointer;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="153", severity=Severity.MUST, title="Use 429 With Header For Rate Limits")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/zalando/zally/ruleset/zalando/Use429HeaderForRateLimitRule;", "", "()V", "description", "", "xRateLimitHeaders", "", "checkHeadersForRateLimiting", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "violatingResponse", "", "entry", "", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "zally-ruleset-zalando"})
public final class Use429HeaderForRateLimitRule {
    private final String description = "Response has to contain rate limit information via headers";
    private final List<String> xRateLimitHeaders = CollectionsKt.listOf((Object[])new String[]{"X-RateLimit-Limit", "X-RateLimit-Remaining", "X-RateLimit-Reset"});

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkHeadersForRateLimiting(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ Use429HeaderForRateLimitRule this$0;
            final /* synthetic */ Context $context;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $$_$_operation) {
                List list;
                Intrinsics.checkParameterIsNotNull($$_$_operation, (String)"<name for destructuring parameter 0>");
                Operation operation = $$_$_operation;
                boolean bl = false;
                Operation operation2 = operation.getValue();
                Operation operation3 = operation2;
                if (operation3 != null && (operation3 = operation3.getResponses()) != null) {
                    void $this$flatMapTo$iv$iv;
                    Map.Entry<K, V> element$iv$iv;
                    Map $this$filterTo$iv$iv;
                    operation = operation3;
                    bl = false;
                    boolean bl2 = false;
                    Operation responses = operation;
                    boolean bl3 = false;
                    Map $this$filter$iv = (Map)responses;
                    boolean $i$f$filter = false;
                    Map map = $this$filter$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    void var13_13 = $this$filterTo$iv$iv;
                    boolean bl4 = false;
                    Iterator<Map.Entry<K, V>> iterator = var13_13.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> it = element$iv$iv = iterator.next();
                        boolean bl5 = false;
                        if (!Use429HeaderForRateLimitRule.access$violatingResponse(this.this$0, it)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    Map $this$flatMap$iv = destination$iv$iv;
                    boolean $i$f$flatMap = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    var13_13 = $this$flatMapTo$iv$iv;
                    bl4 = false;
                    iterator = var13_13.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> $status_$_$ = element$iv$iv = iterator.next();
                        boolean bl6 = false;
                        Map.Entry<K, V> entry = $status_$_$;
                        boolean bl7 = false;
                        String status = (String)entry.getKey();
                        String string = Use429HeaderForRateLimitRule.access$getDescription$p(this.this$0);
                        JsonPointer jsonPointer = this.$context.getJsonPointer((Object)responses);
                        String string2 = status;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"status");
                        Iterable list$iv$iv = this.$context.violations(string, JsonPointerExtensionsKt.plus((JsonPointer)jsonPointer, (JsonPointer)JsonPointerExtensionsKt.toEscapedJsonPointer((String)string2)));
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                operation = list;
                bl = false;
                Object object = operation;
                if (object == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
            {
                this.this$0 = use429HeaderForRateLimitRule;
                this.$context = context;
                super(1);
            }
        }), (int)3, null);
    }

    private final boolean violatingResponse(Map.Entry<String, ? extends ApiResponse> entry) {
        ApiResponse apiResponse = entry.getValue();
        Map map = apiResponse != null ? apiResponse.getHeaders() : null;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Set headers = map2.keySet();
        return Intrinsics.areEqual((Object)"429", (Object)entry.getKey()) && !headers.contains("Retry-After") && !headers.containsAll((Collection)this.xRateLimitHeaders);
    }

    public static final /* synthetic */ boolean access$violatingResponse(Use429HeaderForRateLimitRule $this, Map.Entry entry) {
        return $this.violatingResponse(entry);
    }

    public static final /* synthetic */ String access$getDescription$p(Use429HeaderForRateLimitRule $this) {
        return $this.description;
    }
}

