/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.fasterxml.jackson.core.JsonPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="215", severity=Severity.MUST, title="Provide API Identifier")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/zalando/zally/ruleset/zalando/ApiIdentifierRule;", "", "()V", "apiIdPattern", "Lkotlin/text/Regex;", "extensionName", "", "extensionPointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "invalidApiIdDesc", "noApiIdDesc", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class ApiIdentifierRule {
    private final Regex apiIdPattern;
    private final String noApiIdDesc;
    private final String invalidApiIdDesc;
    private final String extensionName;
    private final JsonPointer extensionPointer;

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation validate(@NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object2 = context.getApi().getInfo();
        Object apiId = object2 != null && (object2 = object2.getExtensions()) != null ? object2.get(this.extensionName) : null;
        if (apiId == null || !(apiId instanceof String)) {
            object = context.violation(this.noApiIdDesc, this.extensionPointer);
        } else {
            CharSequence charSequence = apiId;
            Regex regex = this.apiIdPattern;
            boolean bl = false;
            object = !regex.matches(charSequence) ? context.violation(this.invalidApiIdDesc, this.extensionPointer) : null;
        }
        return object;
    }

    public ApiIdentifierRule() {
        String string = "^[a-z0-9][a-z0-9-:.]{6,62}[a-z0-9]$";
        boolean bl = false;
        this.apiIdPattern = new Regex(string);
        this.noApiIdDesc = "API Identifier should be provided";
        this.invalidApiIdDesc = "API Identifier doesn't match the pattern " + this.apiIdPattern;
        this.extensionName = "x-api-id";
        this.extensionPointer = JsonPointerExtensionsKt.toJsonPointer((String)("/info/" + this.extensionName));
    }
}

