/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.util.PatternUtil;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="146", severity=Severity.SHOULD, title="Limit number of resource types")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0013J!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/zalando/zally/ruleset/zalando/LimitNumberOfResourcesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "pathWhitelist", "", "Lkotlin/text/Regex;", "resourceTypesLimit", "", "checkLimitOfResources", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "isWhitelisted", "", "path", "", "resourceType", "resourceType$zally_ruleset_zalando", "resourceTypes", "paths", "", "resourceTypes$zally_ruleset_zalando", "zally-ruleset-zalando"})
public final class LimitNumberOfResourcesRule {
    private final int resourceTypesLimit;
    private final List<Regex> pathWhitelist;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @Nullable
    public final Violation checkLimitOfResources(@NotNull Context context) {
        Violation violation;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)context.getApi().getPaths();
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Iterable $this$filterNot$iv = map2.keySet();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string = it;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
            if (this.isWhitelisted(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        List<String> resourceTypes = this.resourceTypes$zally_ruleset_zalando(paths);
        if (resourceTypes.size() > this.resourceTypesLimit) {
            String string = "Identified " + resourceTypes.size() + " resource resource types, " + "greater than recommended limit of " + this.resourceTypesLimit;
            Paths paths2 = context.getApi().getPaths();
            Intrinsics.checkNotNullExpressionValue((Object)paths2, (String)"context.api.paths");
            violation = context.violation(string, (Object)paths2);
        } else {
            violation = null;
        }
        return violation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> resourceTypes$zally_ruleset_zalando(@NotNull Collection<String> paths) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Iterable iterable = paths;
        LimitNumberOfResourcesRule limitNumberOfResourcesRule = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = limitNumberOfResourcesRule.resourceType$zally_ruleset_zalando((String)p1);
            collection.add(string2);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String resourceType$zally_ruleset_zalando(@NotNull String path) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = path;
        Regex regex = new Regex("/+");
        int n = 0;
        boolean bl = false;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p1 = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence2 = p1;
            boolean bl3 = false;
            if (!(charSequence2.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List components = (List)destination$iv$iv;
        int size = components.size();
        Function1 function1 = null;
        iterable = null;
        int n2 = 0;
        CharSequence charSequence3 = null;
        CharSequence charSequence4 = "/";
        CharSequence charSequence5 = "/";
        return CollectionsKt.joinToString$default((Iterable)(size > 0 && PatternUtil.INSTANCE.isPathVariable((String)components.get(size - 1)) ? CollectionsKt.dropLast((List)components, (int)1) : (size > 1 && PatternUtil.INSTANCE.isPathVariable((String)components.get(size - 2)) ? CollectionsKt.dropLast((List)components, (int)2) : components)), (CharSequence)charSequence4, (CharSequence)charSequence5, charSequence3, (int)n2, (CharSequence)((Object)iterable), function1, (int)60, null);
    }

    public final boolean isWhitelisted(@NotNull String path) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$any$iv = this.pathWhitelist;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)path)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public LimitNumberOfResourcesRule(@NotNull Config rulesConfig) {
        Collection<Regex> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        this.resourceTypesLimit = rulesConfig.getConfig(this.getClass().getSimpleName()).getInt("resource_types_limit");
        List list = rulesConfig.getConfig(this.getClass().getSimpleName()).getStringList("path_whitelist");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rulesConfig.getConfig(ja\u2026ingList(\"path_whitelist\")");
        Iterable iterable = list;
        LimitNumberOfResourcesRule limitNumberOfResourcesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void var11_12;
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            boolean bl2 = false;
            Regex regex = new Regex((String)var11_12);
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        limitNumberOfResourcesRule.pathWhitelist = collection;
    }
}

