/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.PatternUtil;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="147", severity=Severity.SHOULD, title="Limit number of Sub-resources level")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/zalando/zally/ruleset/zalando/LimitNumberOfSubResourcesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "description", "", "subResourcesLimit", "", "checkNumberOfSubResources", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class LimitNumberOfSubResourcesRule {
    private final int subResourcesLimit;
    private final String description;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkNumberOfSubResources(@NotNull Context context) {
        Pair $dstr$numberOfSubResources$_u24__u24;
        Iterable $this$filterTo$iv$iv;
        Violation violation;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)context.getApi().getPaths();
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Iterable $this$map$iv = map2.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv2;
            void path;
            void $dstr$path$pathObj;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var11_11 = $dstr$path$pathObj;
            boolean bl3 = false;
            String string = (String)var11_11.getKey();
            var11_11 = $dstr$path$pathObj;
            bl3 = false;
            PathItem pathObj = (PathItem)var11_11.getValue();
            void v1 = path;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"path");
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((CharSequence)v1), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                CharSequence charSequence = it;
                boolean bl5 = false;
                if (!(charSequence.length() > 0 && !PatternUtil.INSTANCE.isPathVariable(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            PathItem pathItem = pathObj;
            Integer n = list.size() - 1;
            violation = new Pair((Object)n, (Object)pathItem);
            collection.add(violation);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            $dstr$numberOfSubResources$_u24__u24 = (Pair)element$iv$iv;
            boolean bl6 = false;
            int numberOfSubResources = ((Number)$dstr$numberOfSubResources$_u24__u24.component1()).intValue();
            if (!(numberOfSubResources > this.subResourcesLimit)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$_u24__u24$pathObj;
            PathItem pathObj;
            $dstr$numberOfSubResources$_u24__u24 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            PathItem pathItem = pathObj = (PathItem)$dstr$_u24__u24$pathObj.component2();
            Intrinsics.checkNotNullExpressionValue((Object)pathItem, (String)"pathObj");
            violation = context.violation(this.description, (Object)pathItem);
            collection.add(violation);
        }
        return (List)destination$iv$iv;
    }

    public LimitNumberOfSubResourcesRule(@NotNull Config rulesConfig) {
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        this.subResourcesLimit = rulesConfig.getConfig(this.getClass().getSimpleName()).getInt("subresources_limit");
        this.description = "Number of sub-resources should not exceed " + this.subResourcesLimit;
    }
}

