/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="105", severity=Severity.MUST, title="Secure All Endpoints With Scopes")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0017H\u0002J:\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00112\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/zalando/zally/ruleset/zalando/SecureAllEndpointsWithScopesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "pathWhitelist", "", "Lkotlin/text/Regex;", "scopeRegex", "checkDefinedScopeFormats", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkOperationsAreScoped", "definedSecurityRequirements", "Lio/swagger/v3/oas/models/security/SecurityRequirement;", "operation", "Lio/swagger/v3/oas/models/Operation;", "api", "Lio/swagger/v3/oas/models/OpenAPI;", "pathFilter", "", "entry", "", "", "Lio/swagger/v3/oas/models/PathItem;", "validateOAuth2Schema", "op", "requestedScopes", "definedScheme", "Lio/swagger/v3/oas/models/security/SecurityScheme;", "schemeName", "zally-ruleset-zalando"})
public final class SecureAllEndpointsWithScopesRule {
    private final Regex scopeRegex;
    private final List<Regex> pathWhitelist;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkDefinedScopeFormats(@NotNull Context context) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        SecurityScheme it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApi().getComponents();
        Collection collection = object != null && (object = object.getSecuritySchemes()) != null ? object.values() : null;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = collection2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SecurityScheme)element$iv$iv;
            boolean bl2 = false;
            SecurityScheme securityScheme = it;
            Intrinsics.checkNotNullExpressionValue((Object)securityScheme, (String)"it");
            if (!OpenApiUtilKt.isOAuth2((SecurityScheme)securityScheme)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SecurityScheme)element$iv$iv;
            boolean bl3 = false;
            list$iv$iv = OpenApiUtilKt.allFlows((SecurityScheme)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String scope;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            OAuthFlow flow = (OAuthFlow)element$iv$iv;
            boolean bl4 = false;
            Object object2 = (Map)flow.getScopes();
            boolean bl5 = false;
            Object object3 = object2;
            if (object3 == null) {
                object3 = MapsKt.emptyMap();
            }
            object2 = object3.keySet();
            boolean $i$f$filterNot = false;
            void var13_13 = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                scope = (String)element$iv$iv2;
                boolean bl6 = false;
                String string = scope;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scope");
                if (this.scopeRegex.matches((CharSequence)string)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filterNot$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                scope = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl7 = false;
                String string = "scope '" + scope + "' does not match regex '" + this.scopeRegex + '\'';
                Scopes scopes = flow.getScopes();
                Intrinsics.checkNotNullExpressionValue((Object)scopes, (String)"flow.scopes");
                Violation violation = context.violation(string, (Object)scopes);
                collection3.add(violation);
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkOperationsAreScoped(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map securitySchemes = OpenApiUtilKt.getAllSecuritySchemes((OpenAPI)context.getApi());
        return Context.DefaultImpls.validateOperations$default((Context)context, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends PathItem>, Boolean>(this){

            public final boolean invoke(@NotNull Map.Entry<String, ? extends PathItem> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                return SecureAllEndpointsWithScopesRule.access$pathFilter((SecureAllEndpointsWithScopesRule)this.receiver, p1);
            }
        }), null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context, securitySchemes){
            final /* synthetic */ SecureAllEndpointsWithScopesRule this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Map $securitySchemes;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $dstr$_u24__u24$op) {
                List list;
                Operation op;
                Intrinsics.checkNotNullParameter($dstr$_u24__u24$op, (String)"<name for destructuring parameter 0>");
                Operation operation = $dstr$_u24__u24$op;
                boolean bl = false;
                Operation operation2 = op = operation.getValue();
                if (operation2 != null) {
                    operation = operation2;
                    bl = false;
                    boolean bl2 = false;
                    Operation it = operation;
                    boolean bl3 = false;
                    List definedOpSecurityRequirements = SecureAllEndpointsWithScopesRule.access$definedSecurityRequirements(this.this$0, op, this.$context.getApi());
                    if (definedOpSecurityRequirements.isEmpty()) {
                        List list2 = op.getSecurity();
                        if (list2 == null) {
                            list2 = op;
                        }
                        list = this.$context.violations("Endpoint is not secured by scope(s)", (Object)list2);
                    } else {
                        void $this$flatMapTo$iv$iv;
                        Iterable $this$flatMap$iv = definedOpSecurityRequirements;
                        boolean $i$f$flatMap = false;
                        Iterable iterable = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                            void $this$mapTo$iv$iv;
                            SecurityRequirement it2 = (SecurityRequirement)element$iv$iv;
                            boolean bl4 = false;
                            Map $this$map$iv = (Map)it2;
                            boolean $i$f$map = false;
                            Map map = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv.size());
                            boolean $i$f$mapTo = false;
                            void var23_23 = $this$mapTo$iv$iv;
                            boolean bl5 = false;
                            Iterator<Map.Entry<K, V>> iterator = var23_23.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Violation violation;
                                void opSchemeName;
                                void $dstr$opSchemeName$opScopes;
                                Map.Entry<K, V> item$iv$iv;
                                Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                                Collection collection = destination$iv$iv2;
                                boolean bl6 = false;
                                void var30_30 = $dstr$opSchemeName$opScopes;
                                boolean bl7 = false;
                                String string = (String)var30_30.getKey();
                                var30_30 = $dstr$opSchemeName$opScopes;
                                bl7 = false;
                                List opScopes = (List)var30_30.getValue();
                                SecurityScheme matchingScheme = (SecurityScheme)this.$securitySchemes.get(opSchemeName);
                                if (matchingScheme == null) {
                                    violation = this.$context.violation("Security scheme " + (String)opSchemeName + " not found", (Object)op);
                                } else if (OpenApiUtilKt.isOAuth2((SecurityScheme)matchingScheme)) {
                                    List list3 = opScopes;
                                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"opScopes");
                                    void v5 = opSchemeName;
                                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"opSchemeName");
                                    violation = SecureAllEndpointsWithScopesRule.access$validateOAuth2Schema(this.this$0, this.$context, op, list3, matchingScheme, (String)v5);
                                } else {
                                    violation = null;
                                }
                                Violation violation2 = violation;
                                collection.add(violation2);
                            }
                            Iterable list$iv$iv = (List)destination$iv$iv2;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                    }
                } else {
                    list = null;
                }
                operation = list;
                bl = false;
                Object object = operation;
                if (object == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
            {
                this.this$0 = secureAllEndpointsWithScopesRule;
                this.$context = context;
                this.$securitySchemes = map;
                super(1);
            }
        }), (int)2, null);
    }

    private final List<SecurityRequirement> definedSecurityRequirements(Operation operation, OpenAPI api) {
        List operationSecurity;
        List list = operation.getSecurity();
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = operationSecurity = CollectionsKt.emptyList();
        }
        if (operationSecurity.isEmpty()) {
            list = api.getSecurity();
            bl = false;
            List list3 = list;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            return list3;
        }
        return operationSecurity;
    }

    /*
     * WARNING - void declaration
     */
    private final Violation validateOAuth2Schema(Context context, Operation op, List<String> requestedScopes, SecurityScheme definedScheme, String schemeName) {
        Violation violation;
        void $this$filterNotTo$iv$iv;
        if (requestedScopes.isEmpty()) {
            List list = op.getSecurity();
            if (list == null) {
                list = op;
            }
            return context.violation("Endpoint is not secured by OAuth2 scope(s)", (Object)list);
        }
        List definedScopes = OpenApiUtilKt.allScopes((SecurityScheme)definedScheme);
        Iterable $this$filterNot$iv = CollectionsKt.filterNotNull((Iterable)requestedScopes);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String sc = (String)element$iv$iv;
            boolean bl = false;
            if (definedScopes.contains(sc)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List undefined = (List)destination$iv$iv;
        Collection collection = undefined;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String string = "Endpoint is secured by undefined OAuth2 scope(s): " + schemeName + ':' + CollectionsKt.joinToString$default((Iterable)undefined, null, null, null, (int)0, null, null, (int)63, null);
            List list = op.getSecurity();
            if (list == null) {
                list = op;
            }
            violation = context.violation(string, (Object)list);
        } else {
            violation = null;
        }
        return violation;
    }

    private final boolean pathFilter(Map.Entry<String, ? extends PathItem> entry) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.pathWhitelist;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.containsMatchIn((CharSequence)entry.getKey())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public SecureAllEndpointsWithScopesRule(@NotNull Config rulesConfig) {
        Collection<Regex> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        String string = rulesConfig.getString(SecureAllEndpointsWithScopesRule.class.getSimpleName() + ".scope_regex");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rulesConfig.getString(\n \u2026e}.scope_regex\"\n        )");
        this.scopeRegex = new Regex(string);
        List list = rulesConfig.getStringList(SecureAllEndpointsWithScopesRule.class.getSimpleName() + ".path_whitelist");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rulesConfig.getStringLis\u2026me}.path_whitelist\"\n    )");
        Iterable iterable = list;
        SecureAllEndpointsWithScopesRule secureAllEndpointsWithScopesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void var11_12;
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            boolean bl2 = false;
            Regex regex = new Regex((String)var11_12);
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        secureAllEndpointsWithScopesRule.pathWhitelist = collection;
    }

    public static final /* synthetic */ boolean access$pathFilter(SecureAllEndpointsWithScopesRule $this, Map.Entry entry) {
        return $this.pathFilter(entry);
    }

    public static final /* synthetic */ List access$definedSecurityRequirements(SecureAllEndpointsWithScopesRule $this, Operation operation, OpenAPI api) {
        return $this.definedSecurityRequirements(operation, api);
    }

    public static final /* synthetic */ Violation access$validateOAuth2Schema(SecureAllEndpointsWithScopesRule $this, Context context, Operation op, List requestedScopes, SecurityScheme definedScheme, String schemeName) {
        return $this.validateOAuth2Schema(context, op, requestedScopes, definedScheme, schemeName);
    }
}

