/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="110", severity=Severity.MUST, title="Response As JSON Object")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/zalando/zally/ruleset/zalando/SuccessResponseAsJsonObjectRule;", "", "()V", "description", "", "checkJSONObjectIsUsedAsSuccessResponseType", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "isSuccess", "", "codeString", "zally-ruleset-zalando"})
public final class SuccessResponseAsJsonObjectRule {
    private final String description;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkJSONObjectIsUsedAsSuccessResponseType(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Schema schema;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object list$iv$iv;
        boolean bl;
        Object object;
        void $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        Object $this$flatMap$iv;
        boolean $i$f$flatMap;
        boolean bl2;
        Object object2;
        PathItem it;
        Iterable $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)context.getApi().getPaths();
        boolean bl3 = false;
        Map map2 = map;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Iterable $this$flatMap$iv2 = map2.values();
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (PathItem)element$iv$iv;
            boolean bl4 = false;
            PathItem pathItem = it;
            object2 = pathItem != null ? pathItem.readOperations() : null;
            bl2 = false;
            Object object3 = object2;
            if (object3 == null) {
                object3 = CollectionsKt.emptyList();
            }
            object2 = (Iterable)object3;
            $i$f$flatMap = false;
            void var13_19 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Operation it2 = (Operation)element$iv$iv2;
                boolean bl5 = false;
                Operation operation = it2;
                Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"it");
                object = (Map)operation.getResponses();
                bl = false;
                Object object4 = object;
                if (object4 == null) {
                    object4 = MapsKt.emptyMap();
                }
                object = object4;
                boolean $i$f$filter = false;
                void var22_33 = $this$filter$iv;
                Map destination$iv$iv3 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                void var25_36 = $this$filterTo$iv$iv;
                boolean bl6 = false;
                Iterator iterator = var25_36.entrySet().iterator();
                while (iterator.hasNext()) {
                    String resCode;
                    Map.Entry element$iv$iv3;
                    Map.Entry $dstr$resCode$_u24__u24 = element$iv$iv3 = iterator.next();
                    boolean bl7 = false;
                    Map.Entry entry = $dstr$resCode$_u24__u24;
                    boolean bl8 = false;
                    String string = resCode = (String)entry.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resCode");
                    if (!this.isSuccess(string)) continue;
                    destination$iv$iv3.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
                }
                Iterable list$iv$iv2 = destination$iv$iv3.values();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            it = (ApiResponse)element$iv$iv;
            boolean bl9 = false;
            PathItem pathItem = it;
            $this$flatMap$iv = (Map)(pathItem != null ? pathItem.getContent() : null);
            $i$f$flatMap = false;
            Object object5 = $this$flatMap$iv;
            if (object5 == null) {
                object5 = MapsKt.emptyMap();
            }
            $this$flatMap$iv = object5.entrySet();
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                String mediaType;
                Map.Entry $dstr$mediaType$_u24__u24 = (Map.Entry)element$iv$iv2;
                boolean bl10 = false;
                object = $dstr$mediaType$_u24__u24;
                bl = false;
                String string = mediaType = (String)object.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mediaType");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"json", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Schema schema2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl11 = false;
            Map.Entry it3 = (Map.Entry)element$iv$iv;
            boolean bl12 = false;
            MediaType mediaType = (MediaType)it3.getValue();
            if ((mediaType != null ? mediaType.getSchema() : null) == null) continue;
            schema2 = schema2;
            boolean bl13 = false;
            boolean bl14 = false;
            Schema it$iv$iv = schema2;
            boolean bl15 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$filterNot = false;
        $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            schema = (Schema)element$iv$iv;
            boolean bl16 = false;
            object2 = schema.getType();
            bl2 = false;
            boolean bl17 = false;
            if (object2 == null || object2.length() == 0 || Intrinsics.areEqual((Object)"object", (Object)schema.getType())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            schema = (Schema)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl18 = false;
            Violation violation = context.violation(this.description, (Object)schema);
            collection.add(violation);
        }
        return (List)destination$iv$iv2;
    }

    private final boolean isSuccess(String codeString) {
        int n = 200;
        IntRange intRange = new IntRange(n, 299);
        Integer n2 = StringsKt.toIntOrNull((String)codeString);
        boolean bl = false;
        return n2 != null && intRange.contains(n2.intValue());
    }

    public SuccessResponseAsJsonObjectRule() {
        this.description = "Always return JSON objects as top-level data structures to support extensibility";
    }
}

