/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="240", severity=Severity.SHOULD, title="Declare enum values using UPPER_SNAKE_CASE format")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/zalando/zally/ruleset/zalando/UpperCaseEnums;", "", "()V", "description", "", "pattern", "Lkotlin/text/Regex;", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "validateAllProperties", "validateEnum", "scheme", "Lio/swagger/v3/oas/models/media/Schema;", "validatePrimitiveSchemas", "zally-ruleset-zalando"})
public final class UpperCaseEnums {
    private final Regex pattern;
    private final String description;

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CollectionsKt.plus((Collection)this.validatePrimitiveSchemas(context), (Iterable)this.validateAllProperties(context));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Violation> validateAllProperties(Context context) {
        void $this$flatMapTo$iv$iv;
        Map.Entry it;
        Map.Entry element$iv$iv;
        Map $this$filterTo$iv$iv;
        Map $this$filter$iv = OpenApiUtilKt.getAllProperties((OpenAPI)context.getApi());
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Map map2 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)((Schema)it.getValue()).getType(), (Object)"string")) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        map2 = $this$filterTo$iv$iv;
        bl = false;
        iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = iterator.next();
            boolean bl3 = false;
            if (!(OpenApiUtilKt.isExtensibleEnum((Schema)((Schema)it.getValue())) || OpenApiUtilKt.isEnum((Schema)((Schema)it.getValue())))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$flatMap$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        map2 = $this$flatMapTo$iv$iv;
        bl = false;
        iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $dstr$_u24__u24$property = element$iv$iv = iterator.next();
            boolean bl4 = false;
            Map.Entry entry = $dstr$_u24__u24$property;
            boolean bl5 = false;
            Schema property = (Schema)entry.getValue();
            Iterable list$iv$iv = this.validateEnum((Schema<Object>)property, context);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Violation> validatePrimitiveSchemas(Context context) {
        void $this$flatMapTo$iv$iv;
        Schema it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = OpenApiUtilKt.getAllSchemas((OpenAPI)context.getApi());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Schema)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"string")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Schema)element$iv$iv;
            boolean bl = false;
            if (!(OpenApiUtilKt.isExtensibleEnum((Schema)it) || OpenApiUtilKt.isEnum((Schema)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Schema)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.validateEnum((Schema<Object>)it, context);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Violation> validateEnum(Schema<Object> scheme, Context context) {
        String string;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        Collection collection;
        Object item$iv$iv2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        Object element$iv$iv2;
        Iterable $this$filterNotTo$iv$iv;
        List enumValues;
        List list = enumValues = OpenApiUtilKt.isExtensibleEnum(scheme) ? OpenApiUtilKt.extensibleEnum(scheme) : scheme.getEnum();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"enumValues");
        Iterable $this$filterNot$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv2 = iterator.next();
            boolean bl = false;
            if (it instanceof String) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv2 = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            object = context.violation(scheme.getName() + ": Enum value type " + it.getClass().getSimpleName() + " is not valid. The expected type is string", scheme);
            collection.add(object);
        }
        $this$map$iv = enumValues;
        collection = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv2 = iterator.next();
            boolean bl = false;
            if (!(it instanceof String)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        object = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv2 = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            string = String.valueOf(it);
            object.add(string);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object;
        $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv2;
            boolean bl = false;
            if (this.pattern.matches((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        object = (List)destination$iv$iv;
        $this$filterNot$iv = (Iterable)object;
        $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            string = context.violation(scheme.getName() + ": " + this.description + ". Incorrect value: " + it, scheme);
            object.add(string);
        }
        object = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
    }

    public UpperCaseEnums() {
        String string = "[A-Z_0-9]*";
        boolean bl = false;
        this.pattern = new Regex(string);
        this.description = "Enum value(s) should use UPPER_SNAKE_CASE format";
    }
}

