/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="150", severity=Severity.MUST, title="Use Standard HTTP Status Codes")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u001c\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/zalando/zally/ruleset/zalando/UseStandardHttpStatusCodesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "standardResponseCodes", "", "", "kotlin.jvm.PlatformType", "", "wellUnderstoodResponseCode", "", "wellUnderstoodResponseCodesAndVerbs", "", "checkIfOnlyStandardizedResponseCodesAreUsed", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkIfOnlyWellUnderstoodResponseCodesAreUsed", "checkWellUnderstoodResponseCodesUsage", "isAllowed", "", "method", "Lio/swagger/v3/oas/models/PathItem$HttpMethod;", "statusCode", "zally-ruleset-zalando"})
public final class UseStandardHttpStatusCodesRule {
    private final Map<String, List<String>> wellUnderstoodResponseCodesAndVerbs;
    private final Set<String> wellUnderstoodResponseCode;
    private final List<String> standardResponseCodes;

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkWellUnderstoodResponseCodesUsage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ UseStandardHttpStatusCodesRule this$0;
            final /* synthetic */ Context $context;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $dstr$method$operation) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                boolean bl;
                Map.Entry<K, V> entry;
                Map.Entry<K, V> $dstr$status$_u24__u24;
                void $this$filterNotTo$iv$iv;
                Map $this$filterNot$iv;
                Operation operation;
                Intrinsics.checkNotNullParameter($dstr$method$operation, (String)"<name for destructuring parameter 0>");
                Object object = $dstr$method$operation;
                boolean bl2 = false;
                PathItem.HttpMethod httpMethod = object.getKey();
                object = $dstr$method$operation;
                bl2 = false;
                Operation operation2 = operation = object.getValue();
                object = (Map)(operation2 != null ? operation2.getResponses() : null);
                bl2 = false;
                Object object2 = object;
                if (object2 == null) {
                    object2 = MapsKt.emptyMap();
                }
                object = object2;
                boolean $i$f$filterNot = false;
                void var6_6 = $this$filterNot$iv;
                Object destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterNotTo = false;
                void var9_9 = $this$filterNotTo$iv$iv;
                boolean bl3 = false;
                Iterator<Map.Entry<K, V>> iterator = var9_9.entrySet().iterator();
                while (iterator.hasNext()) {
                    void method;
                    String status;
                    Map.Entry<K, V> element$iv$iv;
                    $dstr$status$_u24__u24 = element$iv$iv = iterator.next();
                    boolean bl4 = false;
                    entry = $dstr$status$_u24__u24;
                    bl = false;
                    String string = status = (String)entry.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"status");
                    if (UseStandardHttpStatusCodesRule.access$isAllowed(this.this$0, (PathItem.HttpMethod)method, string)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filterNot$iv = destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                var9_9 = $this$mapTo$iv$iv;
                bl3 = false;
                for (Map.Entry<K, V> item$iv$iv : var9_9.entrySet()) {
                    ApiResponse response;
                    void $dstr$_u24__u24$response;
                    $dstr$status$_u24__u24 = item$iv$iv;
                    Object object3 = destination$iv$iv;
                    boolean bl5 = false;
                    entry = $dstr$_u24__u24$response;
                    bl = false;
                    ApiResponse apiResponse = response = (ApiResponse)entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)apiResponse, (String)"response");
                    Violation violation = this.$context.violation("Operations should use well-understood HTTP status codes", (Object)apiResponse);
                    object3.add(violation);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = useStandardHttpStatusCodesRule;
                this.$context = context;
                super(1);
            }
        }), (int)3, null);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkIfOnlyStandardizedResponseCodesAreUsed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ UseStandardHttpStatusCodesRule this$0;
            final /* synthetic */ Context $context;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $dstr$_u24__u24$operation) {
                void $this$mapTo$iv$iv;
                String status;
                boolean bl;
                Map.Entry<K, V> entry;
                Map.Entry<K, V> $dstr$status$_u24__u24;
                Map $this$filterNotTo$iv$iv;
                Operation operation;
                Intrinsics.checkNotNullParameter($dstr$_u24__u24$operation, (String)"<name for destructuring parameter 0>");
                Object object = $dstr$_u24__u24$operation;
                boolean bl2 = false;
                Operation operation2 = operation = object.getValue();
                object = (Map)(operation2 != null ? operation2.getResponses() : null);
                bl2 = false;
                Object object2 = object;
                if (object2 == null) {
                    object2 = MapsKt.emptyMap();
                }
                Object $this$filterNot$iv = object2;
                boolean $i$f$filterNot = false;
                Object object3 = $this$filterNot$iv;
                Object destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterNotTo = false;
                void var8_8 = $this$filterNotTo$iv$iv;
                boolean bl3 = false;
                Iterator<Map.Entry<K, V>> iterator = var8_8.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    $dstr$status$_u24__u24 = element$iv$iv = iterator.next();
                    boolean bl4 = false;
                    entry = $dstr$status$_u24__u24;
                    bl = false;
                    status = (String)entry.getKey();
                    if (UseStandardHttpStatusCodesRule.access$getStandardResponseCodes$p(this.this$0).contains(status)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map $this$map$iv = destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                var8_8 = $this$mapTo$iv$iv;
                bl3 = false;
                for (Map.Entry<K, V> item$iv$iv : var8_8.entrySet()) {
                    void $dstr$status$response;
                    $dstr$status$_u24__u24 = item$iv$iv;
                    Object object4 = destination$iv$iv;
                    boolean bl5 = false;
                    entry = $dstr$status$response;
                    bl = false;
                    status = (String)entry.getKey();
                    entry = $dstr$status$response;
                    bl = false;
                    ApiResponse response = (ApiResponse)entry.getValue();
                    String string = status + " is not a standardized response code";
                    ApiResponse apiResponse = response;
                    Intrinsics.checkNotNullExpressionValue((Object)apiResponse, (String)"response");
                    Violation violation = this.$context.violation(string, (Object)apiResponse);
                    object4.add(violation);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = useStandardHttpStatusCodesRule;
                this.$context = context;
                super(1);
            }
        }), (int)3, null);
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkIfOnlyWellUnderstoodResponseCodesAreUsed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ UseStandardHttpStatusCodesRule this$0;
            final /* synthetic */ Context $context;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $dstr$_u24__u24$operation) {
                void $this$mapTo$iv$iv;
                String status;
                boolean bl;
                Map.Entry<K, V> entry;
                Map.Entry<K, V> $dstr$status$_u24__u24;
                Map $this$filterNotTo$iv$iv;
                Operation operation;
                Intrinsics.checkNotNullParameter($dstr$_u24__u24$operation, (String)"<name for destructuring parameter 0>");
                Object object = $dstr$_u24__u24$operation;
                boolean bl2 = false;
                Operation operation2 = operation = object.getValue();
                object = (Map)(operation2 != null ? operation2.getResponses() : null);
                bl2 = false;
                Object object2 = object;
                if (object2 == null) {
                    object2 = MapsKt.emptyMap();
                }
                Object $this$filterNot$iv = object2;
                boolean $i$f$filterNot = false;
                Object object3 = $this$filterNot$iv;
                Object destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterNotTo = false;
                void var8_8 = $this$filterNotTo$iv$iv;
                boolean bl3 = false;
                Iterator<Map.Entry<K, V>> iterator = var8_8.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    $dstr$status$_u24__u24 = element$iv$iv = iterator.next();
                    boolean bl4 = false;
                    entry = $dstr$status$_u24__u24;
                    bl = false;
                    status = (String)entry.getKey();
                    if (UseStandardHttpStatusCodesRule.access$getWellUnderstoodResponseCode$p(this.this$0).contains(status)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map $this$map$iv = destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                var8_8 = $this$mapTo$iv$iv;
                bl3 = false;
                for (Map.Entry<K, V> item$iv$iv : var8_8.entrySet()) {
                    void $dstr$status$response;
                    $dstr$status$_u24__u24 = item$iv$iv;
                    Object object4 = destination$iv$iv;
                    boolean bl5 = false;
                    entry = $dstr$status$response;
                    bl = false;
                    status = (String)entry.getKey();
                    entry = $dstr$status$response;
                    bl = false;
                    ApiResponse response = (ApiResponse)entry.getValue();
                    String string = status + " is not a well-understood response code";
                    ApiResponse apiResponse = response;
                    Intrinsics.checkNotNullExpressionValue((Object)apiResponse, (String)"response");
                    Violation violation = this.$context.violation(string, (Object)apiResponse);
                    object4.add(violation);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = useStandardHttpStatusCodesRule;
                this.$context = context;
                super(1);
            }
        }), (int)3, null);
    }

    private final boolean isAllowed(PathItem.HttpMethod method, String statusCode) {
        Object object = statusCode;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        object = this.wellUnderstoodResponseCodesAndVerbs.get(string2);
        bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object allowedMethods = object2;
        return allowedMethods.contains(method.name()) || allowedMethods.contains("ALL");
    }

    /*
     * WARNING - void declaration
     */
    public UseStandardHttpStatusCodesRule(@NotNull Config rulesConfig) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        Set set = rulesConfig.getConfig(this.getClass().getSimpleName() + ".well_understood").entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"rulesConfig\n        .get\u2026ood\")\n        .entrySet()");
        Iterable iterable = set;
        UseStandardHttpStatusCodesRule useStandardHttpStatusCodesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            void $dstr$key$config;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void var11_12 = $dstr$key$config;
            boolean bl2 = false;
            String string = (String)var11_12.getKey();
            var11_12 = $dstr$key$config;
            bl2 = false;
            ConfigValue config = (ConfigValue)var11_12.getValue();
            Object object = config.unwrapped();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            }
            Pair pair = TuplesKt.to((Object)key, (Object)((List)object));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        useStandardHttpStatusCodesRule.wellUnderstoodResponseCodesAndVerbs = MapsKt.toMap((Iterable)collection);
        this.wellUnderstoodResponseCode = this.wellUnderstoodResponseCodesAndVerbs.keySet();
        this.standardResponseCodes = rulesConfig.getStringList(this.getClass().getSimpleName() + ".standard");
    }

    public static final /* synthetic */ boolean access$isAllowed(UseStandardHttpStatusCodesRule $this, PathItem.HttpMethod method, String statusCode) {
        return $this.isAllowed(method, statusCode);
    }

    public static final /* synthetic */ List access$getStandardResponseCodes$p(UseStandardHttpStatusCodesRule $this) {
        return $this.standardResponseCodes;
    }

    public static final /* synthetic */ Set access$getWellUnderstoodResponseCode$p(UseStandardHttpStatusCodesRule $this) {
        return $this.wellUnderstoodResponseCode;
    }
}

