/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="116", severity=Severity.MUST, title="Use Semantic Versioning")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/zalando/zally/ruleset/zalando/VersionInInfoSectionRule;", "", "()V", "description", "", "versionRegex", "Lkotlin/text/Regex;", "getVersionRegex$zally_ruleset_zalando", "()Lkotlin/text/Regex;", "checkAPIVersion", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class VersionInInfoSectionRule {
    private final String description;
    @NotNull
    private final Regex versionRegex;

    @NotNull
    public final Regex getVersionRegex$zally_ruleset_zalando() {
        return this.versionRegex;
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkAPIVersion(@NotNull Context context) {
        Object object;
        String string;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object3 = context.getApi().getInfo();
        if (object3 != null && (object3 = object3.getVersion()) != null) {
            object2 = object3;
            boolean bl = false;
            Object object4 = object2;
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString();
        } else {
            string = null;
        }
        String version = string;
        if (version == null) {
            object = context.violation(this.description + ": version is missing", JsonPointerExtensionsKt.toJsonPointer((String)"/info/version"));
        } else {
            object2 = version;
            Regex regex = this.versionRegex;
            boolean bl = false;
            object = !regex.matches((CharSequence)object2) ? context.violation(this.description + ": incorrect format", JsonPointerExtensionsKt.toJsonPointer((String)"/info/version")) : null;
        }
        return object;
    }

    public VersionInInfoSectionRule() {
        this.description = "Semantic versioning has to be used in format MAJOR.MINOR(.DRAFT)";
        String string = "^\\d+.\\d+(.\\d+)?$";
        boolean bl = false;
        this.versionRegex = new Regex(string);
    }
}

