/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="H001", severity=Severity.HINT, title="Base path can be extracted")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/zalando/zally/ruleset/zally/ExtractBasePathRule;", "", "()V", "findCommonPrefix", "", "s1", "s2", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "violations", "prefix", "target", "zally-ruleset-zally"})
public final class ExtractBasePathRule {
    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.HINT)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        String prefix;
        Set paths;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Paths paths2 = context.getApi().getPaths();
        Set set = paths2 != null ? paths2.keySet() : null;
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = paths = SetsKt.emptySet();
        }
        if (paths.size() < 2) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$reduce$iv = paths;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void s2;
            String string = (String)iterator$iv.next();
            String s1 = (String)accumulator$iv;
            boolean bl2 = false;
            String string2 = s1;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"s1");
            void v3 = s2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"s2");
            accumulator$iv = this.findCommonPrefix(string2, (String)v3);
        }
        String string = prefix = (String)accumulator$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prefix");
        CharSequence charSequence = string;
        boolean bl3 = false;
        return charSequence.length() == 0 ? CollectionsKt.emptyList() : (context.isOpenAPI3() ? this.violations(prefix, "servers' urls") : this.violations(prefix, "basePath"));
    }

    private final List<Violation> violations(String prefix, String target) {
        return CollectionsKt.listOf((Object)new Violation("All paths start with prefix '" + prefix + "' which could be part of " + target + '.', JsonPointerExtensionsKt.toJsonPointer((String)"/paths")));
    }

    private final String findCommonPrefix(String s1, String s2) {
        List parts1 = StringsKt.split$default((CharSequence)s1, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        List parts2 = StringsKt.split$default((CharSequence)s2, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        Iterable $this$takeWhile$iv = CollectionsKt.zip((Iterable)parts1, (Iterable)parts2);
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            Pair $t1_t2 = (Pair)item$iv;
            boolean bl = false;
            String t1 = (String)$t1_t2.component1();
            String t2 = (String)$t1_t2.component2();
            if (!(!StringsKt.startsWith$default((CharSequence)t1, (char)'{', (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)t1, (Object)t2))) break;
            list$iv.add(item$iv);
        }
        Pair pair = CollectionsKt.unzip((Iterable)list$iv);
        List commonParts = (List)pair.component1();
        return CollectionsKt.joinToString$default((Iterable)commonParts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }
}

