/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zally;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zally.ZallyRuleSet;

@Rule(ruleSet=ZallyRuleSet.class, id="M011", severity=Severity.MUST, title="Tag all operations")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"Lorg/zalando/zally/ruleset/zally/TagAllOperationsRule;", "", "()V", "checkDefinedTagsAreDescribed", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkDefinedTagsAreNamed", "checkDefinedTagsAreUsed", "checkOperationTagsAreDefined", "checkOperationsAreTagged", "zally-ruleset-zally"})
public final class TagAllOperationsRule {
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkOperationsAreTagged(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(context){
            final /* synthetic */ Context $context;

            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $$_$_operation) {
                List list;
                Intrinsics.checkParameterIsNotNull($$_$_operation, (String)"<name for destructuring parameter 0>");
                Object object = $$_$_operation;
                boolean bl = false;
                Operation operation = object.getValue();
                if (operation == null) {
                    list = CollectionsKt.emptyList();
                } else {
                    object = operation.getTags();
                    bl = false;
                    Object object2 = object;
                    if (object2 == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    list = object2.isEmpty() ? this.$context.violations("Operation has no tag", (Object)operation) : CollectionsKt.emptyList();
                }
                return list;
            }
            {
                this.$context = context;
                super(1);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkOperationTagsAreDefined(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        List list = context.getApi().getTags();
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tag tag = (Tag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getName();
            collection.add(string);
        }
        Set defined = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(defined, context){
            final /* synthetic */ Set $defined;
            final /* synthetic */ Context $context;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $$_$_operation) {
                void $this$flatMapTo$iv$iv;
                String it;
                Iterable $this$filterTo$iv$iv;
                Operation operation;
                Intrinsics.checkParameterIsNotNull($$_$_operation, (String)"<name for destructuring parameter 0>");
                Object object = $$_$_operation;
                boolean bl = false;
                Operation operation2 = operation = object.getValue();
                object = operation2 != null ? operation2.getTags() : null;
                bl = false;
                Object object2 = object;
                if (object2 == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Iterable $this$filter$iv = (Iterable)object2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!this.$defined.contains(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$filterTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl3 = false;
                    String string = "Tag '" + it + "' is not defined";
                    Operation operation3 = operation;
                    if (operation3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable list$iv$iv = this.$context.violations(string, (Object)operation3);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$defined = set;
                this.$context = context;
                super(1);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkDefinedTagsAreUsed(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable list$iv$iv;
        PathItem it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Paths paths = context.getApi().getPaths();
        Collection collection = paths != null ? paths.values() : null;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = collection2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PathItem)element$iv$iv;
            boolean bl2 = false;
            list$iv$iv = it.readOperations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Operation)element$iv$iv;
            boolean bl3 = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.getTags() : null;
            boolean bl4 = false;
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set used2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$flatMap$iv = context.getApi().getTags();
        $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        if (iterable2 == null) {
            iterable2 = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = iterable2;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tag)element$iv$iv;
            boolean bl5 = false;
            PathItem pathItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)pathItem, (String)"it");
            if (!(!used2.contains(pathItem.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tag)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl6 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Tag '");
            PathItem pathItem = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)pathItem, (String)"it");
            Violation violation = context.violation(stringBuilder.append(pathItem.getName()).append("' is not used").toString(), (Object)it);
            collection3.add(violation);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkDefinedTagsAreNamed(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Tag it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        List list = context.getApi().getTags();
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tag)element$iv$iv;
            boolean bl2 = false;
            Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            if (!(tag.getName() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            Violation violation = context.violation("Tag has no name", (Object)tag);
            collection.add(violation);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkDefinedTagsAreDescribed(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Tag it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        List list = context.getApi().getTags();
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tag)element$iv$iv;
            boolean bl2 = false;
            Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            if (!(tag.getDescription() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Tag '");
            Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            Violation violation = context.violation(stringBuilder.append(tag.getName()).append("' has no description").toString(), (Object)it);
            collection.add(violation);
        }
        return (List)destination$iv$iv;
    }
}

