/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.DummyResponse;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PublicanPullCommand;
import org.zanata.client.commands.PublicanPullOptions;
import org.zanata.client.commands.PublicanPullOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.RestUtil;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

@Test(groups={"unit-tests"})
public class PublicanPullCommandTest {
    IMocksControl control = EasyMock.createControl();
    ISourceDocResource mockSourceDocResource = this.createMock("mockSourceDocResource", ISourceDocResource.class);
    ITranslatedDocResource mockTranslationResources = this.createMock("mockTranslationResources", ITranslatedDocResource.class);

    public void publicanPullPo() throws Exception {
        this.publicanPull(false, false);
    }

    public void publicanPullPotAndPo() throws Exception {
        this.publicanPull(true, false);
    }

    @Test
    public void publicanPullPotAndPoWithLocaleMapping() throws Exception {
        this.publicanPull(true, true);
    }

    @BeforeMethod
    void beforeMethod() {
        this.control.reset();
    }

    <T> T createMock(String name, Class<T> toMock) {
        Object mock = this.control.createMock(name, toMock);
        return (T)mock;
    }

    private void publicanPull(boolean exportPot, boolean mapLocale) throws Exception {
        PublicanPullOptionsImpl opts = new PublicanPullOptionsImpl();
        String projectSlug = "project";
        opts.setProj(projectSlug);
        String versionSlug = "1.0";
        opts.setProjectVersion(versionSlug);
        opts.setDstDir(new File("target/test-output/test2"));
        opts.setExportPot(exportPot);
        opts.setProjectConfig(new File("src/test/resources/test2/zanata.xml"));
        OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
        if (mapLocale) {
            LocaleList locales = new LocaleList();
            locales.add(new LocaleMapping("ja", "ja-JP"));
            opts.setLocaleMapList(locales);
        }
        ArrayList<ResourceMeta> resourceMetaList = new ArrayList<ResourceMeta>();
        resourceMetaList.add(new ResourceMeta("RPM"));
        resourceMetaList.add(new ResourceMeta("sub/RPM"));
        EasyMock.expect((Object)this.mockSourceDocResource.get(null)).andReturn(new DummyResponse(Response.Status.OK, resourceMetaList));
        Resource rpmResource = new Resource("RPM");
        this.mockExpectGetResourceAndReturnResponse(rpmResource);
        Resource subRpmResource = new Resource("sub/RPM");
        this.mockExpectGetResourceAndReturnResponse(subRpmResource);
        LocaleId expectedLocale = mapLocale ? new LocaleId("ja") : new LocaleId("ja-JP");
        TranslationsResource rpmTransJa = new TranslationsResource();
        this.mockExpectGetTranslationsAndReturnResponse("RPM", expectedLocale, rpmTransJa);
        this.mockExpectGetTranslationsAndReturnResponse("sub/RPM", expectedLocale, null);
        ZanataProxyFactory mockRequestFactory = (ZanataProxyFactory)EasyMock.createNiceMock(ZanataProxyFactory.class);
        this.control.replay();
        PublicanPullCommand cmd = new PublicanPullCommand((PublicanPullOptions)opts, mockRequestFactory, this.mockSourceDocResource, this.mockTranslationResources, new URI("http://example.com/"));
        cmd.run();
        this.control.verify();
    }

    private void mockExpectGetResourceAndReturnResponse(Resource entity) {
        String id = entity.getName();
        String docUri = RestUtil.convertToDocumentURIId((String)id);
        StringSet ext = new StringSet("comment;gettext");
        EasyMock.expect((Object)this.mockSourceDocResource.getResource(docUri, (Set)ext)).andReturn(new DummyResponse<Resource>(Response.Status.OK, entity));
    }

    private void mockExpectGetTranslationsAndReturnResponse(String id, LocaleId locale, TranslationsResource entity) {
        String docUri = RestUtil.convertToDocumentURIId((String)id);
        StringSet ext = new StringSet("comment;gettext");
        if (entity != null) {
            EasyMock.expect((Object)this.mockTranslationResources.getTranslations(docUri, locale, (Set)ext)).andReturn(new DummyResponse<TranslationsResource>(Response.Status.OK, entity));
        } else {
            EasyMock.expect((Object)this.mockTranslationResources.getTranslations(docUri, locale, (Set)ext)).andReturn(new DummyResponse<TranslationsResource>(Response.Status.NOT_FOUND, entity));
        }
    }
}

