/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.push;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.zanata.client.commands.glossary.push.GlossaryCSVReader;
import org.zanata.client.commands.glossary.push.GlossaryPushOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.dto.Glossary;
import org.zanata.rest.dto.GlossaryEntry;

@Test(groups={"unit-tests"})
public class GlossaryCSVReaderTest {
    LocaleList locales = new LocaleList();
    GlossaryCSVReader reader = new GlossaryCSVReader();
    IMocksControl control = EasyMock.createControl();
    GlossaryPushOptions mockPushOption;

    @BeforeMethod
    void beforeMethod() {
        this.control.reset();
    }

    @BeforeTest
    public void prepare() {
        this.locales.add(new LocaleMapping("hi"));
    }

    <T> T createMock(String name, Class<T> toMock) {
        Object mock = this.control.createMock(name, toMock);
        return (T)mock;
    }

    @Test
    public void extractGlossaryTest1() throws IOException {
        File sourceFile = new File("src/test/resources/glossary/translate1.csv");
        ArrayList<String> commentHeaders = new ArrayList<String>();
        commentHeaders.add("pos");
        commentHeaders.add("description");
        this.mockPushOption = this.createMock("mockPushGlossaryOption", GlossaryPushOptions.class);
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTransLang()).andReturn((Object)"hi").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTreatSourceCommentsAsTarget()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getCommentCols()).andReturn(commentHeaders).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getBatchSize()).andReturn((Object)300).anyTimes();
        this.reader.setOpts(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        List glossaries = this.reader.extractGlossary(sourceFile);
        Assert.assertEquals((long)1L, (long)glossaries.size());
        Assert.assertEquals((long)2L, (long)((Glossary)glossaries.get(0)).getGlossaryEntries().size());
        for (GlossaryEntry entry : ((Glossary)glossaries.get(0)).getGlossaryEntries()) {
            Assert.assertEquals((long)3L, (long)entry.getGlossaryTerms().size());
        }
    }

    @Test
    public void extractGlossaryTest2() throws IOException {
        File sourceFile = new File("src/test/resources/glossary/translate2.csv");
        ArrayList<String> commentHeaders = new ArrayList<String>();
        commentHeaders.add("description1");
        commentHeaders.add("description2");
        commentHeaders.add("description3");
        this.mockPushOption = this.createMock("mockPushGlossaryOption", GlossaryPushOptions.class);
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTransLang()).andReturn((Object)"hi").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTreatSourceCommentsAsTarget()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getCommentCols()).andReturn(commentHeaders).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getBatchSize()).andReturn((Object)300).anyTimes();
        this.reader.setOpts(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        List glossaries = this.reader.extractGlossary(sourceFile);
        Assert.assertEquals((long)1L, (long)glossaries.size());
        Assert.assertEquals((long)2L, (long)((Glossary)glossaries.get(0)).getGlossaryEntries().size());
        for (GlossaryEntry entry : ((Glossary)glossaries.get(0)).getGlossaryEntries()) {
            Assert.assertEquals((long)3L, (long)entry.getGlossaryTerms().size());
        }
    }
}

