/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.fedorahosted.openprops.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.zanata.client.commands.pull.PropertiesStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.UTF8PropertiesStrategy;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;

@Test
public class PullPropertiesStrategyTest {
    IMocksControl control = EasyMock.createControl();
    File outDir = new File("target/test-output/writeprops/");
    Properties props = new Properties();
    PullOptions opts;
    Resource doc;

    public PullPropertiesStrategyTest() {
        this.outDir.mkdirs();
        this.opts = (PullOptions)this.control.createMock(PullOptions.class);
        EasyMock.expect((Object)this.opts.getSrcDir()).andReturn((Object)this.outDir).anyTimes();
        this.control.replay();
        this.doc = new Resource(null);
        this.doc.getTextFlows().add(this.newTextFlow("key", "value"));
        this.doc.getTextFlows().add(this.newTextFlow("unicode", "\u30ec\u30b9"));
    }

    @Test
    public void utf8() throws Exception {
        UTF8PropertiesStrategy strat = new UTF8PropertiesStrategy();
        strat.setPullOptions(this.opts);
        this.doc.setName("utf8");
        strat.writeSrcFile(this.doc);
        File f = new File(this.outDir, "utf8.properties");
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
        this.props.load((Reader)r);
        this.checkResults(this.props);
    }

    @Test
    public void latin1() throws Exception {
        PropertiesStrategy strat = new PropertiesStrategy();
        strat.setPullOptions(this.opts);
        this.doc.setName("latin1");
        strat.writeSrcFile(this.doc);
        File f = new File(this.outDir, "latin1.properties");
        FileInputStream inStream = new FileInputStream(f);
        this.props.load((InputStream)inStream);
        this.checkResults(this.props);
    }

    private TextFlow newTextFlow(String key, String value) {
        TextFlow tf = new TextFlow();
        tf.setId(key);
        tf.setContents(new String[]{value});
        return tf;
    }

    private void checkResults(Properties props) {
        Assert.assertEquals((String)props.getProperty("key"), (String)"value");
        Assert.assertEquals((String)props.getProperty("unicode"), (String)"\u30ec\u30b9");
    }
}

