/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.XliffStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

@Test(groups={"unit-tests"})
public class XliffStrategyTest {
    LocaleList locales = new LocaleList();
    XliffStrategy xliffStrategy;
    IMocksControl control = EasyMock.createControl();
    PushOptions mockPushOption;
    private final File sourceDir = new File("src/test/resources/xliffDir");

    @BeforeTest
    public void prepare() {
        this.locales.add(new LocaleMapping("de"));
        this.locales.add(new LocaleMapping("fr"));
    }

    @BeforeMethod
    void beforeMethod() {
        this.control.reset();
    }

    <T> T createMock(String name, Class<T> toMock) {
        Object mock = this.control.createMock(name, toMock);
        return (T)mock;
    }

    @Test
    public void findDocNamesTest() throws IOException {
        XliffStrategy xliffStrategy = new XliffStrategy();
        this.mockPushOption = this.createMock("mockPushOption", PushOptions.class);
        ArrayList<String> include = new ArrayList<String>();
        include.add("**/**StringResource_en_US*");
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getDefaultExcludes()).andReturn((Object)true).anyTimes();
        xliffStrategy.setPushOptions(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        Set localDocNames = xliffStrategy.findDocNames(this.sourceDir, include, new ArrayList(), this.mockPushOption.getDefaultExcludes());
        this.control.verify();
        for (String docName : localDocNames) {
            System.out.println("findDocNamesTest || Source doc name:" + docName);
        }
        System.out.println("findDocNamesTest || Total source docs:" + localDocNames.size());
        Assert.assertEquals((long)3L, (long)localDocNames.size());
    }

    @Test
    public void loadSrcDocTest() throws IOException {
        XliffStrategy xliffStrategy = new XliffStrategy();
        this.mockPushOption = this.createMock("mockPushOption", PushOptions.class);
        ArrayList<String> include = new ArrayList<String>();
        include.add("**/**StringResource_en_US*");
        EasyMock.expect((Object)this.mockPushOption.getTransDir()).andReturn((Object)this.sourceDir).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getDefaultExcludes()).andReturn((Object)true).anyTimes();
        xliffStrategy.setPushOptions(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        Set localDocNames = xliffStrategy.findDocNames(this.sourceDir, include, new ArrayList(), this.mockPushOption.getDefaultExcludes());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String docName : localDocNames) {
            Resource srcDoc = xliffStrategy.loadSrcDoc(this.sourceDir, docName);
            resourceList.add(srcDoc);
            PushCommand.TranslationResourcesVisitor visitor = (PushCommand.TranslationResourcesVisitor)EasyMock.createMock((String)("visitor" + resourceList.size()), PushCommand.TranslationResourcesVisitor.class);
            LocaleMapping loc = srcDoc.getName().equals("dir1/StringResource") ? new LocaleMapping("de") : new LocaleMapping("fr");
            visitor.visit((LocaleMapping)EasyMock.eq((Object)loc), (TranslationsResource)EasyMock.anyObject(TranslationsResource.class));
            EasyMock.replay((Object[])new Object[]{visitor});
            xliffStrategy.visitTranslationResources(docName, srcDoc, visitor);
            EasyMock.verify((Object[])new Object[]{visitor});
        }
        System.out.println("loadSrcDocTest || Total source docs:" + localDocNames.size());
        this.control.verify();
        Assert.assertEquals((long)3L, (long)resourceList.size());
    }

    @Test
    public void loadSrcDocTestWithExcludeFileOption() throws IOException {
        XliffStrategy xliffStrategy = new XliffStrategy();
        this.mockPushOption = this.createMock("mockPushOption", PushOptions.class);
        ArrayList<String> include = new ArrayList<String>();
        include.add("**/**StringResource_en_US*");
        EasyMock.expect((Object)this.mockPushOption.getTransDir()).andReturn((Object)this.sourceDir).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getDefaultExcludes()).andReturn((Object)true).anyTimes();
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add("**/*StringResource*");
        xliffStrategy.setPushOptions(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        Set localDocNames = xliffStrategy.findDocNames(this.sourceDir, include, exclude, this.mockPushOption.getDefaultExcludes());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String docName : localDocNames) {
            Resource srcDoc = xliffStrategy.loadSrcDoc(this.sourceDir, docName);
            resourceList.add(srcDoc);
            PushCommand.TranslationResourcesVisitor visitor = (PushCommand.TranslationResourcesVisitor)EasyMock.createMock((String)("visitor" + resourceList.size()), PushCommand.TranslationResourcesVisitor.class);
            LocaleMapping loc = srcDoc.getName().equals("dir1/StringResource") ? new LocaleMapping("de") : new LocaleMapping("fr");
            visitor.visit((LocaleMapping)EasyMock.eq((Object)loc), (TranslationsResource)EasyMock.anyObject(TranslationsResource.class));
            EasyMock.replay((Object[])new Object[]{visitor});
            xliffStrategy.visitTranslationResources(docName, srcDoc, visitor);
            EasyMock.verify((Object[])new Object[]{visitor});
        }
        System.out.println("loadSrcDocTestWithExcludeFileOption || Total source docs:" + localDocNames.size());
        this.control.verify();
        Assert.assertEquals((long)0L, (long)resourceList.size());
    }

    @Test
    public void loadSrcDocTestWithExcludeOption() throws IOException {
        XliffStrategy xliffStrategy = new XliffStrategy();
        this.mockPushOption = this.createMock("mockPushOption", PushOptions.class);
        ArrayList<String> include = new ArrayList<String>();
        include.add("**/**StringResource_en_US*");
        EasyMock.expect((Object)this.mockPushOption.getTransDir()).andReturn((Object)this.sourceDir).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getDefaultExcludes()).andReturn((Object)true).anyTimes();
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add("**/dir2/*");
        xliffStrategy.setPushOptions(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        Set localDocNames = xliffStrategy.findDocNames(this.sourceDir, include, exclude, this.mockPushOption.getDefaultExcludes());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String docName : localDocNames) {
            Resource srcDoc = xliffStrategy.loadSrcDoc(this.sourceDir, docName);
            resourceList.add(srcDoc);
            PushCommand.TranslationResourcesVisitor visitor = (PushCommand.TranslationResourcesVisitor)EasyMock.createMock((String)("visitor" + resourceList.size()), PushCommand.TranslationResourcesVisitor.class);
            LocaleMapping loc = srcDoc.getName().equals("dir1/StringResource") ? new LocaleMapping("de") : new LocaleMapping("fr");
            visitor.visit((LocaleMapping)EasyMock.eq((Object)loc), (TranslationsResource)EasyMock.anyObject(TranslationsResource.class));
            EasyMock.replay((Object[])new Object[]{visitor});
            xliffStrategy.visitTranslationResources(docName, srcDoc, visitor);
            EasyMock.verify((Object[])new Object[]{visitor});
        }
        System.out.println("loadSrcDocTestWithExcludeDirOption || Total source docs:" + localDocNames.size());
        this.control.verify();
        Assert.assertEquals((long)1L, (long)resourceList.size());
    }
}

