/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.pull.GettextDirStrategy;
import org.zanata.client.commands.pull.PropertiesStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullStrategy;
import org.zanata.client.commands.pull.UTF8PropertiesStrategy;
import org.zanata.client.commands.pull.XliffStrategy;
import org.zanata.client.commands.pull.XmlStrategy;
import org.zanata.client.commands.push.PushPullType;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.common.LocaleId;
import org.zanata.rest.RestUtil;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PullCommand
extends PushPullCommand<PullOptions> {
    private static final Logger log = LoggerFactory.getLogger(PullCommand.class);
    private static final Map<String, PullStrategy> strategies = new HashMap<String, PullStrategy>();

    public PullCommand(PullOptions opts) {
        super(opts);
        strategies.put("utf8properties", new UTF8PropertiesStrategy());
        strategies.put("properties", new PropertiesStrategy());
        strategies.put("podir", new GettextDirStrategy());
        strategies.put("xliff", new XliffStrategy());
        strategies.put("xml", new XmlStrategy());
    }

    public PullCommand(PullOptions opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory, sourceDocResource, translationResources, uri);
        strategies.put("utf8properties", new UTF8PropertiesStrategy());
        strategies.put("properties", new PropertiesStrategy());
        strategies.put("podir", new GettextDirStrategy());
        strategies.put("xliff", new XliffStrategy());
        strategies.put("xml", new XmlStrategy());
    }

    private PullStrategy getStrategy(String strategyType) {
        PullStrategy strat = strategies.get(strategyType);
        if (strat == null) {
            throw new RuntimeException("unknown project type: " + ((PullOptions)this.getOpts()).getProjectType());
        }
        strat.setPullOptions((PullOptions)this.getOpts());
        return strat;
    }

    private void logOptions() {
        log.info("Server: {}", (Object)((PullOptions)this.getOpts()).getUrl());
        log.info("Project: {}", (Object)((PullOptions)this.getOpts()).getProj());
        log.info("Version: {}", (Object)((PullOptions)this.getOpts()).getProjectVersion());
        log.info("Username: {}", (Object)((PullOptions)this.getOpts()).getUsername());
        log.info("Project type: {}", (Object)((PullOptions)this.getOpts()).getProjectType());
        log.info("Enable modules: {}", (Object)((PullOptions)this.getOpts()).getEnableModules());
        if (((PullOptions)this.getOpts()).getEnableModules()) {
            log.info("Current Module: {}", (Object)((PullOptions)this.getOpts()).getCurrentModule());
            if (((PullOptions)this.getOpts()).isRootModule()) {
                log.info("Root module: YES");
                if (log.isDebugEnabled()) {
                    log.debug("Modules: {}", (Object)StringUtils.join(((PullOptions)this.getOpts()).getAllModules(), (String)", "));
                }
            }
        }
        log.info("Locales to pull: {}", (Object)((PullOptions)this.getOpts()).getLocaleMapList());
        if (((PullOptions)this.getOpts()).getPullType() == PushPullType.Source) {
            log.info("Pulling source documents only");
            log.info("Source-language directory (originals): {}", (Object)((PullOptions)this.getOpts()).getSrcDir());
        } else if (((PullOptions)this.getOpts()).getPullType() == PushPullType.Trans) {
            log.info("Pulling target documents (translations) only");
            log.info("Target-language base directory (translations): {}", (Object)((PullOptions)this.getOpts()).getTransDir());
        } else {
            log.info("Pulling source and target (translation) documents");
            log.info("Source-language directory (originals): {}", (Object)((PullOptions)this.getOpts()).getSrcDir());
            log.info("Target-language base directory (translations): {}", (Object)((PullOptions)this.getOpts()).getTransDir());
        }
        log.info("Create skeletons for untranslated messages/files: {}", (Object)((PullOptions)this.getOpts()).getCreateSkeletons());
        if (((PullOptions)this.getOpts()).isDryRun()) {
            log.info("DRY RUN: no permanent changes will be made");
        }
    }

    @Override
    public void run() throws Exception {
        boolean pullTarget;
        this.logOptions();
        LocaleList locales = ((PullOptions)this.getOpts()).getLocaleMapList();
        if (locales == null) {
            throw new ConfigException("no locales specified");
        }
        PullStrategy strat = this.getStrategy(((PullOptions)this.getOpts()).getProjectType());
        List<String> docNamesForModule = this.getQualifiedDocNamesForCurrentModuleFromServer();
        if (docNamesForModule.isEmpty()) {
            log.info("No documents in remote module: {}; nothing to do", (Object)((PullOptions)this.getOpts()).getCurrentModule());
            return;
        }
        log.info("Pulling {} docs for this module from the server", (Object)docNamesForModule.size());
        log.debug("Doc names: {}", docNamesForModule);
        PushPullType pullType = ((PullOptions)this.getOpts()).getPullType();
        boolean pullSrc = pullType == PushPullType.Both || pullType == PushPullType.Source;
        boolean bl = pullTarget = pullType == PushPullType.Both || pullType == PushPullType.Trans;
        if (pullSrc) {
            log.warn("Pull Type set to '" + (Object)((Object)pullType) + "': existing source-language files may be overwritten/deleted");
            this.confirmWithUser("This will overwrite/delete any existing documents and translations in the above directories.\n");
        } else {
            this.confirmWithUser("This will overwrite/delete any existing translations in the above directory.\n");
        }
        for (String qualifiedDocName : docNamesForModule) {
            Resource doc = null;
            String localDocName = this.unqualifiedDocName(qualifiedDocName);
            String docUri = RestUtil.convertToDocumentURIId((String)qualifiedDocName);
            boolean createSkeletons = ((PullOptions)this.getOpts()).getCreateSkeletons();
            if (strat.needsDocToWriteTrans() || pullSrc || createSkeletons) {
                ClientResponse resourceResponse = this.sourceDocResource.getResource(docUri, (Set)strat.getExtensions());
                ClientUtility.checkResult((ClientResponse)resourceResponse, (URI)this.uri);
                doc = (Resource)resourceResponse.getEntity();
                doc.setName(localDocName);
            }
            if (pullSrc) {
                this.writeSrcDoc(strat, doc);
            }
            if (!pullTarget) continue;
            for (LocaleMapping locMapping : locales) {
                TranslationsResource targetDoc;
                LocaleId locale = new LocaleId(locMapping.getLocale());
                ClientResponse transResponse = this.translationResources.getTranslations(docUri, locale, (Set)strat.getExtensions(), createSkeletons);
                if (transResponse.getResponseStatus() == Response.Status.NOT_FOUND) {
                    targetDoc = null;
                    if (!createSkeletons) {
                        log.info("No translations found in locale {} for document {}", (Object)locale, (Object)localDocName);
                        continue;
                    }
                } else {
                    ClientUtility.checkResult((ClientResponse)transResponse, (URI)this.uri);
                    targetDoc = (TranslationsResource)transResponse.getEntity();
                }
                if (targetDoc == null && !createSkeletons) continue;
                this.writeTargetDoc(strat, localDocName, locMapping, doc, targetDoc);
            }
        }
    }

    private void writeSrcDoc(PullStrategy strat, Resource doc) throws IOException {
        if (!((PullOptions)this.getOpts()).isDryRun()) {
            log.info("Writing source file for document {}", (Object)doc.getName());
            strat.writeSrcFile(doc);
        } else {
            log.info("Writing source file for document {} (skipped due to dry run)", (Object)doc.getName());
        }
    }

    private void writeTargetDoc(PullStrategy strat, String localDocName, LocaleMapping locMapping, Resource docWithLocalName, TranslationsResource targetDoc) throws IOException {
        if (!((PullOptions)this.getOpts()).isDryRun()) {
            log.info("Writing translation file in locale {} for document {}", (Object)locMapping.getLocalLocale(), (Object)localDocName);
            strat.writeTransFile(docWithLocalName, localDocName, locMapping, targetDoc);
        } else {
            log.info("Writing translation file in locale {} for document {} (skipped due to dry run)", (Object)locMapping.getLocalLocale(), (Object)localDocName);
        }
    }
}

